/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import java.io.IOException;
import java.util.Map;

public final class GlobalParameterResourceInner
extends SubResource {
    private Map<String, GlobalParameterSpecification> properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(GlobalParameterResourceInner.class);

    public Map<String, GlobalParameterSpecification> properties() {
        return this.properties;
    }

    public GlobalParameterResourceInner withProperties(Map<String, GlobalParameterSpecification> properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public GlobalParameterResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model GlobalParameterResourceInner"));
        }
        this.properties().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GlobalParameterResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalParameterResourceInner)((Object)jsonReader.readObject(reader -> {
            GlobalParameterResourceInner deserializedGlobalParameterResourceInner = new GlobalParameterResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGlobalParameterResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedGlobalParameterResourceInner.properties = properties = reader.readMap(reader1 -> GlobalParameterSpecification.fromJson(reader1));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGlobalParameterResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGlobalParameterResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedGlobalParameterResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalParameterResourceInner;
        }));
    }
}

