/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Expression;
import java.io.IOException;

public final class FilterActivityTypeProperties
implements JsonSerializable<FilterActivityTypeProperties> {
    private Expression items;
    private Expression condition;
    private static final ClientLogger LOGGER = new ClientLogger(FilterActivityTypeProperties.class);

    public Expression items() {
        return this.items;
    }

    public FilterActivityTypeProperties withItems(Expression items) {
        this.items = items;
        return this;
    }

    public Expression condition() {
        return this.condition;
    }

    public FilterActivityTypeProperties withCondition(Expression condition) {
        this.condition = condition;
        return this;
    }

    public void validate() {
        if (this.items() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property items in model FilterActivityTypeProperties"));
        }
        this.items().validate();
        if (this.condition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property condition in model FilterActivityTypeProperties"));
        }
        this.condition().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("items", (JsonSerializable)this.items);
        jsonWriter.writeJsonField("condition", (JsonSerializable)this.condition);
        return jsonWriter.writeEndObject();
    }

    public static FilterActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FilterActivityTypeProperties)jsonReader.readObject(reader -> {
            FilterActivityTypeProperties deserializedFilterActivityTypeProperties = new FilterActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("items".equals(fieldName)) {
                    deserializedFilterActivityTypeProperties.items = Expression.fromJson(reader);
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedFilterActivityTypeProperties.condition = Expression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilterActivityTypeProperties;
        });
    }
}

