/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class FileServerLinkedServiceTypeProperties
implements JsonSerializable<FileServerLinkedServiceTypeProperties> {
    private Object host;
    private Object userId;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(FileServerLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public FileServerLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object userId() {
        return this.userId;
    }

    public FileServerLinkedServiceTypeProperties withUserId(Object userId) {
        this.userId = userId;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public FileServerLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public FileServerLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model FileServerLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        if (this.userId != null) {
            jsonWriter.writeUntypedField("userId", this.userId);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static FileServerLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileServerLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            FileServerLinkedServiceTypeProperties deserializedFileServerLinkedServiceTypeProperties = new FileServerLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedFileServerLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedFileServerLinkedServiceTypeProperties.userId = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedFileServerLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedFileServerLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileServerLinkedServiceTypeProperties;
        });
    }
}

