/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import java.io.IOException;

public final class CouchbaseLinkedServiceTypeProperties
implements JsonSerializable<CouchbaseLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference credString;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public CouchbaseLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference credString() {
        return this.credString;
    }

    public CouchbaseLinkedServiceTypeProperties withCredString(AzureKeyVaultSecretReference credString) {
        this.credString = credString;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public CouchbaseLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.credString() != null) {
            this.credString().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeJsonField("credString", (JsonSerializable)this.credString);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static CouchbaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CouchbaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            CouchbaseLinkedServiceTypeProperties deserializedCouchbaseLinkedServiceTypeProperties = new CouchbaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedCouchbaseLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("credString".equals(fieldName)) {
                    deserializedCouchbaseLinkedServiceTypeProperties.credString = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedCouchbaseLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCouchbaseLinkedServiceTypeProperties;
        });
    }
}

