/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.LogSettings;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.RedirectIncompatibleRowSettings;
import com.azure.resourcemanager.datafactory.models.SkipErrorFile;
import com.azure.resourcemanager.datafactory.models.StagingSettings;
import java.io.IOException;
import java.util.List;

public final class CopyActivityTypeProperties
implements JsonSerializable<CopyActivityTypeProperties> {
    private CopySource source;
    private CopySink sink;
    private Object translator;
    private Object enableStaging;
    private StagingSettings stagingSettings;
    private Object parallelCopies;
    private Object dataIntegrationUnits;
    private Object enableSkipIncompatibleRow;
    private RedirectIncompatibleRowSettings redirectIncompatibleRowSettings;
    private LogStorageSettings logStorageSettings;
    private LogSettings logSettings;
    private List<Object> preserveRules;
    private List<Object> preserve;
    private Object validateDataConsistency;
    private SkipErrorFile skipErrorFile;
    private static final ClientLogger LOGGER = new ClientLogger(CopyActivityTypeProperties.class);

    public CopySource source() {
        return this.source;
    }

    public CopyActivityTypeProperties withSource(CopySource source) {
        this.source = source;
        return this;
    }

    public CopySink sink() {
        return this.sink;
    }

    public CopyActivityTypeProperties withSink(CopySink sink) {
        this.sink = sink;
        return this;
    }

    public Object translator() {
        return this.translator;
    }

    public CopyActivityTypeProperties withTranslator(Object translator) {
        this.translator = translator;
        return this;
    }

    public Object enableStaging() {
        return this.enableStaging;
    }

    public CopyActivityTypeProperties withEnableStaging(Object enableStaging) {
        this.enableStaging = enableStaging;
        return this;
    }

    public StagingSettings stagingSettings() {
        return this.stagingSettings;
    }

    public CopyActivityTypeProperties withStagingSettings(StagingSettings stagingSettings) {
        this.stagingSettings = stagingSettings;
        return this;
    }

    public Object parallelCopies() {
        return this.parallelCopies;
    }

    public CopyActivityTypeProperties withParallelCopies(Object parallelCopies) {
        this.parallelCopies = parallelCopies;
        return this;
    }

    public Object dataIntegrationUnits() {
        return this.dataIntegrationUnits;
    }

    public CopyActivityTypeProperties withDataIntegrationUnits(Object dataIntegrationUnits) {
        this.dataIntegrationUnits = dataIntegrationUnits;
        return this;
    }

    public Object enableSkipIncompatibleRow() {
        return this.enableSkipIncompatibleRow;
    }

    public CopyActivityTypeProperties withEnableSkipIncompatibleRow(Object enableSkipIncompatibleRow) {
        this.enableSkipIncompatibleRow = enableSkipIncompatibleRow;
        return this;
    }

    public RedirectIncompatibleRowSettings redirectIncompatibleRowSettings() {
        return this.redirectIncompatibleRowSettings;
    }

    public CopyActivityTypeProperties withRedirectIncompatibleRowSettings(RedirectIncompatibleRowSettings redirectIncompatibleRowSettings) {
        this.redirectIncompatibleRowSettings = redirectIncompatibleRowSettings;
        return this;
    }

    public LogStorageSettings logStorageSettings() {
        return this.logStorageSettings;
    }

    public CopyActivityTypeProperties withLogStorageSettings(LogStorageSettings logStorageSettings) {
        this.logStorageSettings = logStorageSettings;
        return this;
    }

    public LogSettings logSettings() {
        return this.logSettings;
    }

    public CopyActivityTypeProperties withLogSettings(LogSettings logSettings) {
        this.logSettings = logSettings;
        return this;
    }

    public List<Object> preserveRules() {
        return this.preserveRules;
    }

    public CopyActivityTypeProperties withPreserveRules(List<Object> preserveRules) {
        this.preserveRules = preserveRules;
        return this;
    }

    public List<Object> preserve() {
        return this.preserve;
    }

    public CopyActivityTypeProperties withPreserve(List<Object> preserve) {
        this.preserve = preserve;
        return this;
    }

    public Object validateDataConsistency() {
        return this.validateDataConsistency;
    }

    public CopyActivityTypeProperties withValidateDataConsistency(Object validateDataConsistency) {
        this.validateDataConsistency = validateDataConsistency;
        return this;
    }

    public SkipErrorFile skipErrorFile() {
        return this.skipErrorFile;
    }

    public CopyActivityTypeProperties withSkipErrorFile(SkipErrorFile skipErrorFile) {
        this.skipErrorFile = skipErrorFile;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model CopyActivityTypeProperties"));
        }
        this.source().validate();
        if (this.sink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sink in model CopyActivityTypeProperties"));
        }
        this.sink().validate();
        if (this.stagingSettings() != null) {
            this.stagingSettings().validate();
        }
        if (this.redirectIncompatibleRowSettings() != null) {
            this.redirectIncompatibleRowSettings().validate();
        }
        if (this.logStorageSettings() != null) {
            this.logStorageSettings().validate();
        }
        if (this.logSettings() != null) {
            this.logSettings().validate();
        }
        if (this.skipErrorFile() != null) {
            this.skipErrorFile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("sink", (JsonSerializable)this.sink);
        if (this.translator != null) {
            jsonWriter.writeUntypedField("translator", this.translator);
        }
        if (this.enableStaging != null) {
            jsonWriter.writeUntypedField("enableStaging", this.enableStaging);
        }
        jsonWriter.writeJsonField("stagingSettings", (JsonSerializable)this.stagingSettings);
        if (this.parallelCopies != null) {
            jsonWriter.writeUntypedField("parallelCopies", this.parallelCopies);
        }
        if (this.dataIntegrationUnits != null) {
            jsonWriter.writeUntypedField("dataIntegrationUnits", this.dataIntegrationUnits);
        }
        if (this.enableSkipIncompatibleRow != null) {
            jsonWriter.writeUntypedField("enableSkipIncompatibleRow", this.enableSkipIncompatibleRow);
        }
        jsonWriter.writeJsonField("redirectIncompatibleRowSettings", (JsonSerializable)this.redirectIncompatibleRowSettings);
        jsonWriter.writeJsonField("logStorageSettings", (JsonSerializable)this.logStorageSettings);
        jsonWriter.writeJsonField("logSettings", (JsonSerializable)this.logSettings);
        jsonWriter.writeArrayField("preserveRules", this.preserveRules, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("preserve", this.preserve, (writer, element) -> writer.writeUntyped(element));
        if (this.validateDataConsistency != null) {
            jsonWriter.writeUntypedField("validateDataConsistency", this.validateDataConsistency);
        }
        jsonWriter.writeJsonField("skipErrorFile", (JsonSerializable)this.skipErrorFile);
        return jsonWriter.writeEndObject();
    }

    public static CopyActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CopyActivityTypeProperties)jsonReader.readObject(reader -> {
            CopyActivityTypeProperties deserializedCopyActivityTypeProperties = new CopyActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.source = CopySource.fromJson(reader);
                    continue;
                }
                if ("sink".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.sink = CopySink.fromJson(reader);
                    continue;
                }
                if ("translator".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.translator = reader.readUntyped();
                    continue;
                }
                if ("enableStaging".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.enableStaging = reader.readUntyped();
                    continue;
                }
                if ("stagingSettings".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.stagingSettings = StagingSettings.fromJson(reader);
                    continue;
                }
                if ("parallelCopies".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.parallelCopies = reader.readUntyped();
                    continue;
                }
                if ("dataIntegrationUnits".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.dataIntegrationUnits = reader.readUntyped();
                    continue;
                }
                if ("enableSkipIncompatibleRow".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.enableSkipIncompatibleRow = reader.readUntyped();
                    continue;
                }
                if ("redirectIncompatibleRowSettings".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.redirectIncompatibleRowSettings = RedirectIncompatibleRowSettings.fromJson(reader);
                    continue;
                }
                if ("logStorageSettings".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.logStorageSettings = LogStorageSettings.fromJson(reader);
                    continue;
                }
                if ("logSettings".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.logSettings = LogSettings.fromJson(reader);
                    continue;
                }
                if ("preserveRules".equals(fieldName)) {
                    List preserveRules;
                    deserializedCopyActivityTypeProperties.preserveRules = preserveRules = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("preserve".equals(fieldName)) {
                    List preserve;
                    deserializedCopyActivityTypeProperties.preserve = preserve = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("validateDataConsistency".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.validateDataConsistency = reader.readUntyped();
                    continue;
                }
                if ("skipErrorFile".equals(fieldName)) {
                    deserializedCopyActivityTypeProperties.skipErrorFile = SkipErrorFile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyActivityTypeProperties;
        });
    }
}

