/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import java.io.IOException;
import java.util.List;

public final class ChainingTriggerTypeProperties
implements JsonSerializable<ChainingTriggerTypeProperties> {
    private List<PipelineReference> dependsOn;
    private String runDimension;
    private static final ClientLogger LOGGER = new ClientLogger(ChainingTriggerTypeProperties.class);

    public List<PipelineReference> dependsOn() {
        return this.dependsOn;
    }

    public ChainingTriggerTypeProperties withDependsOn(List<PipelineReference> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public String runDimension() {
        return this.runDimension;
    }

    public ChainingTriggerTypeProperties withRunDimension(String runDimension) {
        this.runDimension = runDimension;
        return this;
    }

    public void validate() {
        if (this.dependsOn() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dependsOn in model ChainingTriggerTypeProperties"));
        }
        this.dependsOn().forEach(e -> e.validate());
        if (this.runDimension() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property runDimension in model ChainingTriggerTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("runDimension", this.runDimension);
        return jsonWriter.writeEndObject();
    }

    public static ChainingTriggerTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChainingTriggerTypeProperties)jsonReader.readObject(reader -> {
            ChainingTriggerTypeProperties deserializedChainingTriggerTypeProperties = new ChainingTriggerTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedChainingTriggerTypeProperties.dependsOn = dependsOn = reader.readArray(reader1 -> PipelineReference.fromJson(reader1));
                    continue;
                }
                if ("runDimension".equals(fieldName)) {
                    deserializedChainingTriggerTypeProperties.runDimension = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChainingTriggerTypeProperties;
        });
    }
}

