/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureSqlDatabaseAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SqlAlwaysEncryptedProperties;
import com.azure.resourcemanager.datafactory.models.SqlServerBaseLinkedServiceTypeProperties;
import java.io.IOException;

public final class AzureSqlDatabaseLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private AzureSqlDatabaseAuthenticationType authenticationType;
    private Object username;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private String encryptedCredential;
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;
    private CredentialReference credential;

    public Object connectionString() {
        return this.connectionString;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDatabaseAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withAuthenticationType(AzureSqlDatabaseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withServer(Object server) {
        super.withServer(server);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withDatabase(Object database) {
        super.withDatabase(database);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withEncrypt(Object encrypt) {
        super.withEncrypt(encrypt);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withTrustServerCertificate(Object trustServerCertificate) {
        super.withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withHostnameInCertificate(Object hostnameInCertificate) {
        super.withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withApplicationIntent(Object applicationIntent) {
        super.withApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withConnectTimeout(Object connectTimeout) {
        super.withConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withConnectRetryCount(Object connectRetryCount) {
        super.withConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withConnectRetryInterval(Object connectRetryInterval) {
        super.withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withCommandTimeout(Object commandTimeout) {
        super.withCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withIntegratedSecurity(Object integratedSecurity) {
        super.withIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withFailoverPartner(Object failoverPartner) {
        super.withFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withMaxPoolSize(Object maxPoolSize) {
        super.withMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withMinPoolSize(Object minPoolSize) {
        super.withMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withMultiSubnetFailover(Object multiSubnetFailover) {
        super.withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withPacketSize(Object packetSize) {
        super.withPacketSize(packetSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties withPooling(Object pooling) {
        super.withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
        if (this.alwaysEncryptedSettings() != null) {
            this.alwaysEncryptedSettings().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.server() != null) {
            jsonWriter.writeUntypedField("server", this.server());
        }
        if (this.database() != null) {
            jsonWriter.writeUntypedField("database", this.database());
        }
        if (this.encrypt() != null) {
            jsonWriter.writeUntypedField("encrypt", this.encrypt());
        }
        if (this.trustServerCertificate() != null) {
            jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate());
        }
        if (this.hostnameInCertificate() != null) {
            jsonWriter.writeUntypedField("hostNameInCertificate", this.hostnameInCertificate());
        }
        if (this.applicationIntent() != null) {
            jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent());
        }
        if (this.connectTimeout() != null) {
            jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout());
        }
        if (this.connectRetryCount() != null) {
            jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount());
        }
        if (this.connectRetryInterval() != null) {
            jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval());
        }
        if (this.loadBalanceTimeout() != null) {
            jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout());
        }
        if (this.commandTimeout() != null) {
            jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout());
        }
        if (this.integratedSecurity() != null) {
            jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity());
        }
        if (this.failoverPartner() != null) {
            jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner());
        }
        if (this.maxPoolSize() != null) {
            jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize());
        }
        if (this.minPoolSize() != null) {
            jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize());
        }
        if (this.multipleActiveResultSets() != null) {
            jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets());
        }
        if (this.multiSubnetFailover() != null) {
            jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover());
        }
        if (this.packetSize() != null) {
            jsonWriter.writeUntypedField("packetSize", this.packetSize());
        }
        if (this.pooling() != null) {
            jsonWriter.writeUntypedField("pooling", this.pooling());
        }
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("userName", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("alwaysEncryptedSettings", (JsonSerializable)this.alwaysEncryptedSettings);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDatabaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDatabaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureSqlDatabaseLinkedServiceTypeProperties deserializedAzureSqlDatabaseLinkedServiceTypeProperties = new AzureSqlDatabaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withHostnameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.withPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.authenticationType = AzureSqlDatabaseAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("alwaysEncryptedSettings".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.alwaysEncryptedSettings = SqlAlwaysEncryptedProperties.fromJson(reader);
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSqlDatabaseLinkedServiceTypeProperties;
        });
    }
}

