/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureMLWebServiceFile;
import java.io.IOException;
import java.util.Map;

public final class AzureMLBatchExecutionActivityTypeProperties
implements JsonSerializable<AzureMLBatchExecutionActivityTypeProperties> {
    private Map<String, Object> globalParameters;
    private Map<String, AzureMLWebServiceFile> webServiceOutputs;
    private Map<String, AzureMLWebServiceFile> webServiceInputs;

    public Map<String, Object> globalParameters() {
        return this.globalParameters;
    }

    public AzureMLBatchExecutionActivityTypeProperties withGlobalParameters(Map<String, Object> globalParameters) {
        this.globalParameters = globalParameters;
        return this;
    }

    public Map<String, AzureMLWebServiceFile> webServiceOutputs() {
        return this.webServiceOutputs;
    }

    public AzureMLBatchExecutionActivityTypeProperties withWebServiceOutputs(Map<String, AzureMLWebServiceFile> webServiceOutputs) {
        this.webServiceOutputs = webServiceOutputs;
        return this;
    }

    public Map<String, AzureMLWebServiceFile> webServiceInputs() {
        return this.webServiceInputs;
    }

    public AzureMLBatchExecutionActivityTypeProperties withWebServiceInputs(Map<String, AzureMLWebServiceFile> webServiceInputs) {
        this.webServiceInputs = webServiceInputs;
        return this;
    }

    public void validate() {
        if (this.webServiceOutputs() != null) {
            this.webServiceOutputs().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.webServiceInputs() != null) {
            this.webServiceInputs().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("globalParameters", this.globalParameters, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("webServiceOutputs", this.webServiceOutputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("webServiceInputs", this.webServiceInputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureMLBatchExecutionActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLBatchExecutionActivityTypeProperties)jsonReader.readObject(reader -> {
            AzureMLBatchExecutionActivityTypeProperties deserializedAzureMLBatchExecutionActivityTypeProperties = new AzureMLBatchExecutionActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("globalParameters".equals(fieldName)) {
                    Map globalParameters;
                    deserializedAzureMLBatchExecutionActivityTypeProperties.globalParameters = globalParameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("webServiceOutputs".equals(fieldName)) {
                    Map webServiceOutputs;
                    deserializedAzureMLBatchExecutionActivityTypeProperties.webServiceOutputs = webServiceOutputs = reader.readMap(reader1 -> AzureMLWebServiceFile.fromJson(reader1));
                    continue;
                }
                if ("webServiceInputs".equals(fieldName)) {
                    Map webServiceInputs;
                    deserializedAzureMLBatchExecutionActivityTypeProperties.webServiceInputs = webServiceInputs = reader.readMap(reader1 -> AzureMLWebServiceFile.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMLBatchExecutionActivityTypeProperties;
        });
    }
}

