/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureFunctionLinkedServiceTypeProperties
implements JsonSerializable<AzureFunctionLinkedServiceTypeProperties> {
    private Object functionAppUrl;
    private SecretBase functionKey;
    private String encryptedCredential;
    private CredentialReference credential;
    private Object resourceId;
    private Object authentication;
    private static final ClientLogger LOGGER = new ClientLogger(AzureFunctionLinkedServiceTypeProperties.class);

    public Object functionAppUrl() {
        return this.functionAppUrl;
    }

    public AzureFunctionLinkedServiceTypeProperties withFunctionAppUrl(Object functionAppUrl) {
        this.functionAppUrl = functionAppUrl;
        return this;
    }

    public SecretBase functionKey() {
        return this.functionKey;
    }

    public AzureFunctionLinkedServiceTypeProperties withFunctionKey(SecretBase functionKey) {
        this.functionKey = functionKey;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureFunctionLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureFunctionLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object resourceId() {
        return this.resourceId;
    }

    public AzureFunctionLinkedServiceTypeProperties withResourceId(Object resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Object authentication() {
        return this.authentication;
    }

    public AzureFunctionLinkedServiceTypeProperties withAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public void validate() {
        if (this.functionAppUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property functionAppUrl in model AzureFunctionLinkedServiceTypeProperties"));
        }
        if (this.functionKey() != null) {
            this.functionKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("functionAppUrl", this.functionAppUrl);
        jsonWriter.writeJsonField("functionKey", (JsonSerializable)this.functionKey);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        if (this.resourceId != null) {
            jsonWriter.writeUntypedField("resourceId", this.resourceId);
        }
        if (this.authentication != null) {
            jsonWriter.writeUntypedField("authentication", this.authentication);
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureFunctionLinkedServiceTypeProperties deserializedAzureFunctionLinkedServiceTypeProperties = new AzureFunctionLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("functionAppUrl".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.functionAppUrl = reader.readUntyped();
                    continue;
                }
                if ("functionKey".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.functionKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.resourceId = reader.readUntyped();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedAzureFunctionLinkedServiceTypeProperties.authentication = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFunctionLinkedServiceTypeProperties;
        });
    }
}

