/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionResource;
import java.io.IOException;

public final class SqlUserDefinedFunctionGetPropertiesResource
extends SqlUserDefinedFunctionResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(SqlUserDefinedFunctionGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SqlUserDefinedFunctionGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SqlUserDefinedFunctionGetPropertiesResource withBody(String body) {
        super.withBody(body);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model SqlUserDefinedFunctionGetPropertiesResource"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("body", this.body());
        return jsonWriter.writeEndObject();
    }

    public static SqlUserDefinedFunctionGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlUserDefinedFunctionGetPropertiesResource)jsonReader.readObject(reader -> {
            SqlUserDefinedFunctionGetPropertiesResource deserializedSqlUserDefinedFunctionGetPropertiesResource = new SqlUserDefinedFunctionGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.withBody(reader.getString());
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedSqlUserDefinedFunctionGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlUserDefinedFunctionGetPropertiesResource;
        });
    }
}

