/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DistanceFunction;
import com.azure.resourcemanager.cosmos.models.VectorDataType;
import java.io.IOException;

public final class VectorEmbedding
implements JsonSerializable<VectorEmbedding> {
    private String path;
    private VectorDataType dataType;
    private DistanceFunction distanceFunction;
    private int dimensions;
    private static final ClientLogger LOGGER = new ClientLogger(VectorEmbedding.class);

    public String path() {
        return this.path;
    }

    public VectorEmbedding withPath(String path) {
        this.path = path;
        return this;
    }

    public VectorDataType dataType() {
        return this.dataType;
    }

    public VectorEmbedding withDataType(VectorDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public DistanceFunction distanceFunction() {
        return this.distanceFunction;
    }

    public VectorEmbedding withDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
        return this;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public VectorEmbedding withDimensions(int dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model VectorEmbedding"));
        }
        if (this.dataType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataType in model VectorEmbedding"));
        }
        if (this.distanceFunction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property distanceFunction in model VectorEmbedding"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeStringField("distanceFunction", this.distanceFunction == null ? null : this.distanceFunction.toString());
        jsonWriter.writeIntField("dimensions", this.dimensions);
        return jsonWriter.writeEndObject();
    }

    public static VectorEmbedding fromJson(JsonReader jsonReader) throws IOException {
        return (VectorEmbedding)jsonReader.readObject(reader -> {
            VectorEmbedding deserializedVectorEmbedding = new VectorEmbedding();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedVectorEmbedding.path = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedVectorEmbedding.dataType = VectorDataType.fromString(reader.getString());
                    continue;
                }
                if ("distanceFunction".equals(fieldName)) {
                    deserializedVectorEmbedding.distanceFunction = DistanceFunction.fromString(reader.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    deserializedVectorEmbedding.dimensions = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorEmbedding;
        });
    }
}

