/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.OperationType;
import com.azure.resourcemanager.cosmos.models.RestorableSqlContainerPropertiesResourceContainer;
import java.io.IOException;

public final class RestorableSqlContainerPropertiesResource
implements JsonSerializable<RestorableSqlContainerPropertiesResource> {
    private String rid;
    private OperationType operationType;
    private String canUndelete;
    private String canUndeleteReason;
    private String eventTimestamp;
    private String ownerId;
    private String ownerResourceId;
    private RestorableSqlContainerPropertiesResourceContainer container;

    public String rid() {
        return this.rid;
    }

    public OperationType operationType() {
        return this.operationType;
    }

    public String canUndelete() {
        return this.canUndelete;
    }

    public String canUndeleteReason() {
        return this.canUndeleteReason;
    }

    public String eventTimestamp() {
        return this.eventTimestamp;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String ownerResourceId() {
        return this.ownerResourceId;
    }

    public RestorableSqlContainerPropertiesResourceContainer container() {
        return this.container;
    }

    public RestorableSqlContainerPropertiesResource withContainer(RestorableSqlContainerPropertiesResourceContainer container) {
        this.container = container;
        return this;
    }

    public void validate() {
        if (this.container() != null) {
            this.container().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("container", (JsonSerializable)this.container);
        return jsonWriter.writeEndObject();
    }

    public static RestorableSqlContainerPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableSqlContainerPropertiesResource)jsonReader.readObject(reader -> {
            RestorableSqlContainerPropertiesResource deserializedRestorableSqlContainerPropertiesResource = new RestorableSqlContainerPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("_rid".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("operationType".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.operationType = OperationType.fromString(reader.getString());
                    continue;
                }
                if ("canUndelete".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.canUndelete = reader.getString();
                    continue;
                }
                if ("canUndeleteReason".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.canUndeleteReason = reader.getString();
                    continue;
                }
                if ("eventTimestamp".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.eventTimestamp = reader.getString();
                    continue;
                }
                if ("ownerId".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.ownerId = reader.getString();
                    continue;
                }
                if ("ownerResourceId".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.ownerResourceId = reader.getString();
                    continue;
                }
                if ("container".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.container = RestorableSqlContainerPropertiesResourceContainer.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableSqlContainerPropertiesResource;
        });
    }
}

