/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AutoscaleSettings;
import java.io.IOException;

public class OptionsResource
implements JsonSerializable<OptionsResource> {
    private Integer throughput;
    private AutoscaleSettings autoscaleSettings;

    public Integer throughput() {
        return this.throughput;
    }

    public OptionsResource withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    public AutoscaleSettings autoscaleSettings() {
        return this.autoscaleSettings;
    }

    public OptionsResource withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        this.autoscaleSettings = autoscaleSettings;
        return this;
    }

    public void validate() {
        if (this.autoscaleSettings() != null) {
            this.autoscaleSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", (Number)this.throughput);
        jsonWriter.writeJsonField("autoscaleSettings", (JsonSerializable)this.autoscaleSettings);
        return jsonWriter.writeEndObject();
    }

    public static OptionsResource fromJson(JsonReader jsonReader) throws IOException {
        return (OptionsResource)jsonReader.readObject(reader -> {
            OptionsResource deserializedOptionsResource = new OptionsResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("throughput".equals(fieldName)) {
                    deserializedOptionsResource.throughput = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoscaleSettings".equals(fieldName)) {
                    deserializedOptionsResource.autoscaleSettings = AutoscaleSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOptionsResource;
        });
    }
}

