/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DefaultConsistencyLevel;
import java.io.IOException;

public final class ConsistencyPolicy
implements JsonSerializable<ConsistencyPolicy> {
    private DefaultConsistencyLevel defaultConsistencyLevel;
    private Long maxStalenessPrefix;
    private Integer maxIntervalInSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(ConsistencyPolicy.class);

    public DefaultConsistencyLevel defaultConsistencyLevel() {
        return this.defaultConsistencyLevel;
    }

    public ConsistencyPolicy withDefaultConsistencyLevel(DefaultConsistencyLevel defaultConsistencyLevel) {
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        return this;
    }

    public Long maxStalenessPrefix() {
        return this.maxStalenessPrefix;
    }

    public ConsistencyPolicy withMaxStalenessPrefix(Long maxStalenessPrefix) {
        this.maxStalenessPrefix = maxStalenessPrefix;
        return this;
    }

    public Integer maxIntervalInSeconds() {
        return this.maxIntervalInSeconds;
    }

    public ConsistencyPolicy withMaxIntervalInSeconds(Integer maxIntervalInSeconds) {
        this.maxIntervalInSeconds = maxIntervalInSeconds;
        return this;
    }

    public void validate() {
        if (this.defaultConsistencyLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property defaultConsistencyLevel in model ConsistencyPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultConsistencyLevel", this.defaultConsistencyLevel == null ? null : this.defaultConsistencyLevel.toString());
        jsonWriter.writeNumberField("maxStalenessPrefix", (Number)this.maxStalenessPrefix);
        jsonWriter.writeNumberField("maxIntervalInSeconds", (Number)this.maxIntervalInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static ConsistencyPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ConsistencyPolicy)jsonReader.readObject(reader -> {
            ConsistencyPolicy deserializedConsistencyPolicy = new ConsistencyPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultConsistencyLevel".equals(fieldName)) {
                    deserializedConsistencyPolicy.defaultConsistencyLevel = DefaultConsistencyLevel.fromString(reader.getString());
                    continue;
                }
                if ("maxStalenessPrefix".equals(fieldName)) {
                    deserializedConsistencyPolicy.maxStalenessPrefix = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maxIntervalInSeconds".equals(fieldName)) {
                    deserializedConsistencyPolicy.maxIntervalInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsistencyPolicy;
        });
    }
}

