/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CassandraSchema;
import com.azure.resourcemanager.cosmos.models.CassandraTableResource;
import java.io.IOException;

public final class CassandraTableGetPropertiesResource
extends CassandraTableResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraTableGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public CassandraTableGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withSchema(CassandraSchema schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public CassandraTableGetPropertiesResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model CassandraTableGetPropertiesResource"));
        }
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl());
        jsonWriter.writeJsonField("schema", (JsonSerializable)this.schema());
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl());
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraTableGetPropertiesResource)jsonReader.readObject(reader -> {
            CassandraTableGetPropertiesResource deserializedCassandraTableGetPropertiesResource = new CassandraTableGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withDefaultTtl((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withSchema(CassandraSchema.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.withAnalyticalStorageTtl((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedCassandraTableGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraTableGetPropertiesResource;
        });
    }
}

