/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlContainerResource;
import java.io.IOException;

public final class SqlContainerCreateUpdateProperties
implements JsonSerializable<SqlContainerCreateUpdateProperties> {
    private SqlContainerResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerCreateUpdateProperties.class);

    public SqlContainerResource resource() {
        return this.resource;
    }

    public SqlContainerCreateUpdateProperties withResource(SqlContainerResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public SqlContainerCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model SqlContainerCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static SqlContainerCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlContainerCreateUpdateProperties)jsonReader.readObject(reader -> {
            SqlContainerCreateUpdateProperties deserializedSqlContainerCreateUpdateProperties = new SqlContainerCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedSqlContainerCreateUpdateProperties.resource = SqlContainerResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedSqlContainerCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlContainerCreateUpdateProperties;
        });
    }
}

