/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.MinimalTlsVersion;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

public final class DatabaseAccountCreateUpdateProperties
implements JsonSerializable<DatabaseAccountCreateUpdateProperties> {
    private ConsistencyPolicy consistencyPolicy;
    private List<Location> locations;
    private final String databaseAccountOfferType = "Standard";
    private List<IpAddressOrRange> ipRules;
    private Boolean isVirtualNetworkFilterEnabled;
    private Boolean enableAutomaticFailover;
    private List<Capability> capabilities;
    private List<VirtualNetworkRule> virtualNetworkRules;
    private Boolean enableMultipleWriteLocations;
    private Boolean enableCassandraConnector;
    private ConnectorOffer connectorOffer;
    private Boolean disableKeyBasedMetadataWriteAccess;
    private String keyVaultKeyUri;
    private String defaultIdentity;
    private PublicNetworkAccess publicNetworkAccess;
    private Boolean enableFreeTier;
    private ApiProperties apiProperties;
    private Boolean enableAnalyticalStorage;
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;
    private CreateMode createMode;
    private BackupPolicy backupPolicy;
    private List<CorsPolicy> cors;
    private NetworkAclBypass networkAclBypass;
    private List<String> networkAclBypassResourceIds;
    private Boolean disableLocalAuth;
    private RestoreParameters restoreParameters;
    private Capacity capacity;
    private DatabaseAccountKeysMetadata keysMetadata;
    private Boolean enablePartitionMerge;
    private MinimalTlsVersion minimalTlsVersion;
    private Boolean enableBurstCapacity;
    private String customerManagedKeyStatus;
    private Boolean enablePerRegionPerPartitionAutoscale;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountCreateUpdateProperties.class);

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountCreateUpdateProperties withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public DatabaseAccountCreateUpdateProperties withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    public String databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    public DatabaseAccountCreateUpdateProperties withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountCreateUpdateProperties withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountCreateUpdateProperties withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountCreateUpdateProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountCreateUpdateProperties withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountCreateUpdateProperties withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountCreateUpdateProperties withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountCreateUpdateProperties withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountCreateUpdateProperties withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    public DatabaseAccountCreateUpdateProperties withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    public DatabaseAccountCreateUpdateProperties withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DatabaseAccountCreateUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    public DatabaseAccountCreateUpdateProperties withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    public DatabaseAccountCreateUpdateProperties withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    public DatabaseAccountCreateUpdateProperties withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    public DatabaseAccountCreateUpdateProperties withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseAccountCreateUpdateProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    public DatabaseAccountCreateUpdateProperties withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.cors;
    }

    public DatabaseAccountCreateUpdateProperties withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    public DatabaseAccountCreateUpdateProperties withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    public DatabaseAccountCreateUpdateProperties withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DatabaseAccountCreateUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public RestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public DatabaseAccountCreateUpdateProperties withRestoreParameters(RestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public DatabaseAccountCreateUpdateProperties withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.keysMetadata;
    }

    public Boolean enablePartitionMerge() {
        return this.enablePartitionMerge;
    }

    public DatabaseAccountCreateUpdateProperties withEnablePartitionMerge(Boolean enablePartitionMerge) {
        this.enablePartitionMerge = enablePartitionMerge;
        return this;
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public DatabaseAccountCreateUpdateProperties withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public Boolean enableBurstCapacity() {
        return this.enableBurstCapacity;
    }

    public DatabaseAccountCreateUpdateProperties withEnableBurstCapacity(Boolean enableBurstCapacity) {
        this.enableBurstCapacity = enableBurstCapacity;
        return this;
    }

    public String customerManagedKeyStatus() {
        return this.customerManagedKeyStatus;
    }

    public DatabaseAccountCreateUpdateProperties withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        this.customerManagedKeyStatus = customerManagedKeyStatus;
        return this;
    }

    public Boolean enablePerRegionPerPartitionAutoscale() {
        return this.enablePerRegionPerPartitionAutoscale;
    }

    public DatabaseAccountCreateUpdateProperties withEnablePerRegionPerPartitionAutoscale(Boolean enablePerRegionPerPartitionAutoscale) {
        this.enablePerRegionPerPartitionAutoscale = enablePerRegionPerPartitionAutoscale;
        return this;
    }

    public void validate() {
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.locations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property locations in model DatabaseAccountCreateUpdateProperties"));
        }
        this.locations().forEach(e -> e.validate());
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.apiProperties() != null) {
            this.apiProperties().validate();
        }
        if (this.analyticalStorageConfiguration() != null) {
            this.analyticalStorageConfiguration().validate();
        }
        if (this.backupPolicy() != null) {
            this.backupPolicy().validate();
        }
        if (this.cors() != null) {
            this.cors().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.keysMetadata() != null) {
            this.keysMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("databaseAccountOfferType", this.databaseAccountOfferType);
        jsonWriter.writeJsonField("consistencyPolicy", (JsonSerializable)this.consistencyPolicy);
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isVirtualNetworkFilterEnabled", this.isVirtualNetworkFilterEnabled);
        jsonWriter.writeBooleanField("enableAutomaticFailover", this.enableAutomaticFailover);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableMultipleWriteLocations", this.enableMultipleWriteLocations);
        jsonWriter.writeBooleanField("enableCassandraConnector", this.enableCassandraConnector);
        jsonWriter.writeStringField("connectorOffer", this.connectorOffer == null ? null : this.connectorOffer.toString());
        jsonWriter.writeBooleanField("disableKeyBasedMetadataWriteAccess", this.disableKeyBasedMetadataWriteAccess);
        jsonWriter.writeStringField("keyVaultKeyUri", this.keyVaultKeyUri);
        jsonWriter.writeStringField("defaultIdentity", this.defaultIdentity);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("enableFreeTier", this.enableFreeTier);
        jsonWriter.writeJsonField("apiProperties", (JsonSerializable)this.apiProperties);
        jsonWriter.writeBooleanField("enableAnalyticalStorage", this.enableAnalyticalStorage);
        jsonWriter.writeJsonField("analyticalStorageConfiguration", (JsonSerializable)this.analyticalStorageConfiguration);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeJsonField("backupPolicy", (JsonSerializable)this.backupPolicy);
        jsonWriter.writeArrayField("cors", this.cors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkAclBypass", this.networkAclBypass == null ? null : this.networkAclBypass.toString());
        jsonWriter.writeArrayField("networkAclBypassResourceIds", this.networkAclBypassResourceIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeBooleanField("enablePartitionMerge", this.enablePartitionMerge);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeBooleanField("enableBurstCapacity", this.enableBurstCapacity);
        jsonWriter.writeStringField("customerManagedKeyStatus", this.customerManagedKeyStatus);
        jsonWriter.writeBooleanField("enablePerRegionPerPartitionAutoscale", this.enablePerRegionPerPartitionAutoscale);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountCreateUpdateProperties)jsonReader.readObject(reader -> {
            DatabaseAccountCreateUpdateProperties deserializedDatabaseAccountCreateUpdateProperties = new DatabaseAccountCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedDatabaseAccountCreateUpdateProperties.locations = locations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    continue;
                }
                if ("consistencyPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.consistencyPolicy = ConsistencyPolicy.fromJson(reader);
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedDatabaseAccountCreateUpdateProperties.ipRules = ipRules = reader.readArray(reader1 -> IpAddressOrRange.fromJson(reader1));
                    continue;
                }
                if ("isVirtualNetworkFilterEnabled".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.isVirtualNetworkFilterEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticFailover".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableAutomaticFailover = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedDatabaseAccountCreateUpdateProperties.capabilities = capabilities = reader.readArray(reader1 -> Capability.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedDatabaseAccountCreateUpdateProperties.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    continue;
                }
                if ("enableMultipleWriteLocations".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableMultipleWriteLocations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableCassandraConnector".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableCassandraConnector = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("connectorOffer".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.connectorOffer = ConnectorOffer.fromString(reader.getString());
                    continue;
                }
                if ("disableKeyBasedMetadataWriteAccess".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.disableKeyBasedMetadataWriteAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultKeyUri".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.keyVaultKeyUri = reader.getString();
                    continue;
                }
                if ("defaultIdentity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.defaultIdentity = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("enableFreeTier".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableFreeTier = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiProperties".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.apiProperties = ApiProperties.fromJson(reader);
                    continue;
                }
                if ("enableAnalyticalStorage".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableAnalyticalStorage = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("analyticalStorageConfiguration".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.analyticalStorageConfiguration = AnalyticalStorageConfiguration.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("backupPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.backupPolicy = BackupPolicy.fromJson(reader);
                    continue;
                }
                if ("cors".equals(fieldName)) {
                    List cors;
                    deserializedDatabaseAccountCreateUpdateProperties.cors = cors = reader.readArray(reader1 -> CorsPolicy.fromJson(reader1));
                    continue;
                }
                if ("networkAclBypass".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.networkAclBypass = NetworkAclBypass.fromString(reader.getString());
                    continue;
                }
                if ("networkAclBypassResourceIds".equals(fieldName)) {
                    List networkAclBypassResourceIds;
                    deserializedDatabaseAccountCreateUpdateProperties.networkAclBypassResourceIds = networkAclBypassResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.restoreParameters = RestoreParameters.fromJson(reader);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.capacity = Capacity.fromJson(reader);
                    continue;
                }
                if ("keysMetadata".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.keysMetadata = DatabaseAccountKeysMetadata.fromJson(reader);
                    continue;
                }
                if ("enablePartitionMerge".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enablePartitionMerge = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.minimalTlsVersion = MinimalTlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("enableBurstCapacity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableBurstCapacity = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customerManagedKeyStatus".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.customerManagedKeyStatus = reader.getString();
                    continue;
                }
                if ("enablePerRegionPerPartitionAutoscale".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enablePerRegionPerPartitionAutoscale = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountCreateUpdateProperties;
        });
    }
}

