/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionPolicy;
import com.azure.resourcemanager.cosmos.models.ComputedProperty;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class SqlContainerResource {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="indexingPolicy")
    private IndexingPolicy indexingPolicy;
    @JsonProperty(value="partitionKey")
    private ContainerPartitionKey partitionKey;
    @JsonProperty(value="defaultTtl")
    private Integer defaultTtl;
    @JsonProperty(value="uniqueKeyPolicy")
    private UniqueKeyPolicy uniqueKeyPolicy;
    @JsonProperty(value="conflictResolutionPolicy")
    private ConflictResolutionPolicy conflictResolutionPolicy;
    @JsonProperty(value="clientEncryptionPolicy")
    private ClientEncryptionPolicy clientEncryptionPolicy;
    @JsonProperty(value="analyticalStorageTtl")
    private Long analyticalStorageTtl;
    @JsonProperty(value="restoreParameters")
    private ResourceRestoreParameters restoreParameters;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="computedProperties")
    private List<ComputedProperty> computedProperties;
    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerResource.class);

    public String id() {
        return this.id;
    }

    public SqlContainerResource withId(String id) {
        this.id = id;
        return this;
    }

    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    public SqlContainerResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    public SqlContainerResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    public SqlContainerResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    public SqlContainerResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public SqlContainerResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public ClientEncryptionPolicy clientEncryptionPolicy() {
        return this.clientEncryptionPolicy;
    }

    public SqlContainerResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        this.clientEncryptionPolicy = clientEncryptionPolicy;
        return this;
    }

    public Long analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public SqlContainerResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public SqlContainerResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public SqlContainerResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public List<ComputedProperty> computedProperties() {
        return this.computedProperties;
    }

    public SqlContainerResource withComputedProperties(List<ComputedProperty> computedProperties) {
        this.computedProperties = computedProperties;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property id in model SqlContainerResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.clientEncryptionPolicy() != null) {
            this.clientEncryptionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.computedProperties() != null) {
            this.computedProperties().forEach(e -> e.validate());
        }
    }
}

