/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolUpgradeProfileProperties;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import java.io.IOException;
import java.util.List;

public final class AgentPoolUpgradeProfileInner
implements JsonSerializable<AgentPoolUpgradeProfileInner> {
    private String id;
    private String name;
    private String type;
    private AgentPoolUpgradeProfileProperties innerProperties = new AgentPoolUpgradeProfileProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolUpgradeProfileInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private AgentPoolUpgradeProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public AgentPoolUpgradeProfileInner withKubernetesVersion(String kubernetesVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withKubernetesVersion(kubernetesVersion);
        return this;
    }

    public OSType osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public AgentPoolUpgradeProfileInner withOsType(OSType osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.innerProperties() == null ? null : this.innerProperties().upgrades();
    }

    public AgentPoolUpgradeProfileInner withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withUpgrades(upgrades);
        return this;
    }

    public String latestNodeImageVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().latestNodeImageVersion();
    }

    public AgentPoolUpgradeProfileInner withLatestNodeImageVersion(String latestNodeImageVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withLatestNodeImageVersion(latestNodeImageVersion);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AgentPoolUpgradeProfileInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolUpgradeProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolUpgradeProfileInner)jsonReader.readObject(reader -> {
            AgentPoolUpgradeProfileInner deserializedAgentPoolUpgradeProfileInner = new AgentPoolUpgradeProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.innerProperties = AgentPoolUpgradeProfileProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolUpgradeProfileInner;
        });
    }
}

