/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.DelegatedResource;
import com.azure.resourcemanager.containerservice.models.ManagedServiceIdentityUserAssignedIdentitiesValue;
import com.azure.resourcemanager.containerservice.models.ResourceIdentityType;
import java.io.IOException;
import java.util.Map;

public final class ManagedClusterIdentity
implements JsonSerializable<ManagedClusterIdentity> {
    private String principalId;
    private String tenantId;
    private ResourceIdentityType type;
    private Map<String, DelegatedResource> delegatedResources;
    private Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public ManagedClusterIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, DelegatedResource> delegatedResources() {
        return this.delegatedResources;
    }

    public ManagedClusterIdentity withDelegatedResources(Map<String, DelegatedResource> delegatedResources) {
        this.delegatedResources = delegatedResources;
        return this;
    }

    public Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ManagedClusterIdentity withUserAssignedIdentities(Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.delegatedResources() != null) {
            this.delegatedResources().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("delegatedResources", this.delegatedResources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterIdentity)jsonReader.readObject(reader -> {
            ManagedClusterIdentity deserializedManagedClusterIdentity = new ManagedClusterIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedManagedClusterIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedManagedClusterIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedClusterIdentity.type = ResourceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("delegatedResources".equals(fieldName)) {
                    Map delegatedResources;
                    deserializedManagedClusterIdentity.delegatedResources = delegatedResources = reader.readMap(reader1 -> DelegatedResource.fromJson(reader1));
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedManagedClusterIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> ManagedServiceIdentityUserAssignedIdentitiesValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterIdentity;
        });
    }
}

