/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.SnapshotType;
import java.io.IOException;

public final class SnapshotProperties
implements JsonSerializable<SnapshotProperties> {
    private CreationData creationData;
    private SnapshotType snapshotType;
    private String kubernetesVersion;
    private String nodeImageVersion;
    private OSType osType;
    private OSSku osSku;
    private String vmSize;
    private Boolean enableFips;

    public CreationData creationData() {
        return this.creationData;
    }

    public SnapshotProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public SnapshotType snapshotType() {
        return this.snapshotType;
    }

    public SnapshotProperties withSnapshotType(SnapshotType snapshotType) {
        this.snapshotType = snapshotType;
        return this;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public String nodeImageVersion() {
        return this.nodeImageVersion;
    }

    public OSType osType() {
        return this.osType;
    }

    public OSSku osSku() {
        return this.osSku;
    }

    public String vmSize() {
        return this.vmSize;
    }

    public Boolean enableFips() {
        return this.enableFips;
    }

    public void validate() {
        if (this.creationData() != null) {
            this.creationData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData);
        jsonWriter.writeStringField("snapshotType", this.snapshotType == null ? null : this.snapshotType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SnapshotProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotProperties)jsonReader.readObject(reader -> {
            SnapshotProperties deserializedSnapshotProperties = new SnapshotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationData".equals(fieldName)) {
                    deserializedSnapshotProperties.creationData = CreationData.fromJson(reader);
                    continue;
                }
                if ("snapshotType".equals(fieldName)) {
                    deserializedSnapshotProperties.snapshotType = SnapshotType.fromString(reader.getString());
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedSnapshotProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("nodeImageVersion".equals(fieldName)) {
                    deserializedSnapshotProperties.nodeImageVersion = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedSnapshotProperties.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("osSku".equals(fieldName)) {
                    deserializedSnapshotProperties.osSku = OSSku.fromString(reader.getString());
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedSnapshotProperties.vmSize = reader.getString();
                    continue;
                }
                if ("enableFIPS".equals(fieldName)) {
                    deserializedSnapshotProperties.enableFips = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotProperties;
        });
    }
}

