/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.DateSpan;
import com.azure.resourcemanager.containerservice.models.Schedule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.List;

public final class MaintenanceWindow {
    @JsonProperty(value="schedule", required=true)
    private Schedule schedule;
    @JsonProperty(value="durationHours", required=true)
    private int durationHours;
    @JsonProperty(value="utcOffset")
    private String utcOffset;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="startTime", required=true)
    private String startTime;
    @JsonProperty(value="notAllowedDates")
    private List<DateSpan> notAllowedDates;
    private static final ClientLogger LOGGER = new ClientLogger(MaintenanceWindow.class);

    public Schedule schedule() {
        return this.schedule;
    }

    public MaintenanceWindow withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public int durationHours() {
        return this.durationHours;
    }

    public MaintenanceWindow withDurationHours(int durationHours) {
        this.durationHours = durationHours;
        return this;
    }

    public String utcOffset() {
        return this.utcOffset;
    }

    public MaintenanceWindow withUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
        return this;
    }

    public LocalDate startDate() {
        return this.startDate;
    }

    public MaintenanceWindow withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public MaintenanceWindow withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public List<DateSpan> notAllowedDates() {
        return this.notAllowedDates;
    }

    public MaintenanceWindow withNotAllowedDates(List<DateSpan> notAllowedDates) {
        this.notAllowedDates = notAllowedDates;
        return this;
    }

    public void validate() {
        if (this.schedule() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property schedule in model MaintenanceWindow"));
        }
        this.schedule().validate();
        if (this.startTime() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property startTime in model MaintenanceWindow"));
        }
        if (this.notAllowedDates() != null) {
            this.notAllowedDates().forEach(e -> e.validate());
        }
    }
}

