/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.BaseImageTriggerUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TimerTriggerUpdateParameters;
import java.io.IOException;
import java.util.List;

public final class TriggerUpdateParameters
implements JsonSerializable<TriggerUpdateParameters> {
    private List<TimerTriggerUpdateParameters> timerTriggers;
    private List<SourceTriggerUpdateParameters> sourceTriggers;
    private BaseImageTriggerUpdateParameters baseImageTrigger;

    public List<TimerTriggerUpdateParameters> timerTriggers() {
        return this.timerTriggers;
    }

    public TriggerUpdateParameters withTimerTriggers(List<TimerTriggerUpdateParameters> timerTriggers) {
        this.timerTriggers = timerTriggers;
        return this;
    }

    public List<SourceTriggerUpdateParameters> sourceTriggers() {
        return this.sourceTriggers;
    }

    public TriggerUpdateParameters withSourceTriggers(List<SourceTriggerUpdateParameters> sourceTriggers) {
        this.sourceTriggers = sourceTriggers;
        return this;
    }

    public BaseImageTriggerUpdateParameters baseImageTrigger() {
        return this.baseImageTrigger;
    }

    public TriggerUpdateParameters withBaseImageTrigger(BaseImageTriggerUpdateParameters baseImageTrigger) {
        this.baseImageTrigger = baseImageTrigger;
        return this;
    }

    public void validate() {
        if (this.timerTriggers() != null) {
            this.timerTriggers().forEach(e -> e.validate());
        }
        if (this.sourceTriggers() != null) {
            this.sourceTriggers().forEach(e -> e.validate());
        }
        if (this.baseImageTrigger() != null) {
            this.baseImageTrigger().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("timerTriggers", this.timerTriggers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sourceTriggers", this.sourceTriggers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("baseImageTrigger", (JsonSerializable)this.baseImageTrigger);
        return jsonWriter.writeEndObject();
    }

    public static TriggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerUpdateParameters)jsonReader.readObject(reader -> {
            TriggerUpdateParameters deserializedTriggerUpdateParameters = new TriggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timerTriggers".equals(fieldName)) {
                    List timerTriggers;
                    deserializedTriggerUpdateParameters.timerTriggers = timerTriggers = reader.readArray(reader1 -> TimerTriggerUpdateParameters.fromJson(reader1));
                    continue;
                }
                if ("sourceTriggers".equals(fieldName)) {
                    List sourceTriggers;
                    deserializedTriggerUpdateParameters.sourceTriggers = sourceTriggers = reader.readArray(reader1 -> SourceTriggerUpdateParameters.fromJson(reader1));
                    continue;
                }
                if ("baseImageTrigger".equals(fieldName)) {
                    deserializedTriggerUpdateParameters.baseImageTrigger = BaseImageTriggerUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerUpdateParameters;
        });
    }
}

