/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CredentialSetProperties
implements JsonSerializable<CredentialSetProperties> {
    private String loginServer;
    private List<AuthCredential> authCredentials;
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;

    public String loginServer() {
        return this.loginServer;
    }

    public CredentialSetProperties withLoginServer(String loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    public CredentialSetProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.authCredentials() != null) {
            this.authCredentials().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loginServer", this.loginServer);
        jsonWriter.writeArrayField("authCredentials", this.authCredentials, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CredentialSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialSetProperties)jsonReader.readObject(reader -> {
            CredentialSetProperties deserializedCredentialSetProperties = new CredentialSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loginServer".equals(fieldName)) {
                    deserializedCredentialSetProperties.loginServer = reader.getString();
                    continue;
                }
                if ("authCredentials".equals(fieldName)) {
                    List authCredentials;
                    deserializedCredentialSetProperties.authCredentials = authCredentials = reader.readArray(reader1 -> AuthCredential.fromJson(reader1));
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedCredentialSetProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCredentialSetProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialSetProperties;
        });
    }
}

