/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GallerySoftDeletedResourceProperties;
import com.azure.resourcemanager.compute.models.SoftDeletedArtifactTypes;
import java.io.IOException;
import java.util.Map;

public final class GallerySoftDeletedResourceInner
extends Resource {
    private GallerySoftDeletedResourceProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private GallerySoftDeletedResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public GallerySoftDeletedResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public GallerySoftDeletedResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String resourceArmId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceArmId();
    }

    public GallerySoftDeletedResourceInner withResourceArmId(String resourceArmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withResourceArmId(resourceArmId);
        return this;
    }

    public SoftDeletedArtifactTypes softDeletedArtifactType() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletedArtifactType();
    }

    public GallerySoftDeletedResourceInner withSoftDeletedArtifactType(SoftDeletedArtifactTypes softDeletedArtifactType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withSoftDeletedArtifactType(softDeletedArtifactType);
        return this;
    }

    public String softDeletedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletedTime();
    }

    public GallerySoftDeletedResourceInner withSoftDeletedTime(String softDeletedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GallerySoftDeletedResourceProperties();
        }
        this.innerProperties().withSoftDeletedTime(softDeletedTime);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GallerySoftDeletedResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (GallerySoftDeletedResourceInner)((Object)jsonReader.readObject(reader -> {
            GallerySoftDeletedResourceInner deserializedGallerySoftDeletedResourceInner = new GallerySoftDeletedResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGallerySoftDeletedResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.innerProperties = GallerySoftDeletedResourceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedGallerySoftDeletedResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGallerySoftDeletedResourceInner;
        }));
    }
}

