// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.UpgradeOperationHistoricalStatusInfoInner;
import java.io.IOException;
import java.util.List;

/**
 * List of Virtual Machine Scale Set OS Upgrade History operation response.
 */
@Fluent
public final class VirtualMachineScaleSetListOSUpgradeHistory
    implements JsonSerializable<VirtualMachineScaleSetListOSUpgradeHistory> {
    /*
     * The list of OS upgrades performed on the virtual machine scale set.
     */
    private List<UpgradeOperationHistoricalStatusInfoInner> value;

    /*
     * The uri to fetch the next page of OS Upgrade History. Call ListNext() with this to fetch the next page of history
     * of upgrades.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineScaleSetListOSUpgradeHistory class.
     */
    public VirtualMachineScaleSetListOSUpgradeHistory() {
    }

    /**
     * Get the value property: The list of OS upgrades performed on the virtual machine scale set.
     * 
     * @return the value value.
     */
    public List<UpgradeOperationHistoricalStatusInfoInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of OS upgrades performed on the virtual machine scale set.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineScaleSetListOSUpgradeHistory object itself.
     */
    public VirtualMachineScaleSetListOSUpgradeHistory withValue(List<UpgradeOperationHistoricalStatusInfoInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of OS Upgrade History. Call ListNext() with this to
     * fetch the next page of history of upgrades.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of OS Upgrade History. Call ListNext() with this to
     * fetch the next page of history of upgrades.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineScaleSetListOSUpgradeHistory object itself.
     */
    public VirtualMachineScaleSetListOSUpgradeHistory withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model VirtualMachineScaleSetListOSUpgradeHistory"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetListOSUpgradeHistory.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetListOSUpgradeHistory from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetListOSUpgradeHistory if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetListOSUpgradeHistory.
     */
    public static VirtualMachineScaleSetListOSUpgradeHistory fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetListOSUpgradeHistory deserializedVirtualMachineScaleSetListOSUpgradeHistory
                = new VirtualMachineScaleSetListOSUpgradeHistory();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<UpgradeOperationHistoricalStatusInfoInner> value
                        = reader.readArray(reader1 -> UpgradeOperationHistoricalStatusInfoInner.fromJson(reader1));
                    deserializedVirtualMachineScaleSetListOSUpgradeHistory.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetListOSUpgradeHistory.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetListOSUpgradeHistory;
        });
    }
}
