// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the hardware settings for the virtual machine scale set.
 */
@Fluent
public final class VirtualMachineScaleSetHardwareProfile
    implements JsonSerializable<VirtualMachineScaleSetHardwareProfile> {
    /*
     * Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please
     * follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    private VMSizeProperties vmSizeProperties;

    /**
     * Creates an instance of VirtualMachineScaleSetHardwareProfile class.
     */
    public VirtualMachineScaleSetHardwareProfile() {
    }

    /**
     * Get the vmSizeProperties property: Specifies the properties for customizing the size of the virtual machine.
     * Minimum api-version: 2021-11-01. Please follow the instructions in [VM
     * Customization](https://aka.ms/vmcustomization) for more details.
     * 
     * @return the vmSizeProperties value.
     */
    public VMSizeProperties vmSizeProperties() {
        return this.vmSizeProperties;
    }

    /**
     * Set the vmSizeProperties property: Specifies the properties for customizing the size of the virtual machine.
     * Minimum api-version: 2021-11-01. Please follow the instructions in [VM
     * Customization](https://aka.ms/vmcustomization) for more details.
     * 
     * @param vmSizeProperties the vmSizeProperties value to set.
     * @return the VirtualMachineScaleSetHardwareProfile object itself.
     */
    public VirtualMachineScaleSetHardwareProfile withVmSizeProperties(VMSizeProperties vmSizeProperties) {
        this.vmSizeProperties = vmSizeProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vmSizeProperties() != null) {
            vmSizeProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vmSizeProperties", this.vmSizeProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetHardwareProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetHardwareProfile if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetHardwareProfile.
     */
    public static VirtualMachineScaleSetHardwareProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetHardwareProfile deserializedVirtualMachineScaleSetHardwareProfile
                = new VirtualMachineScaleSetHardwareProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmSizeProperties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetHardwareProfile.vmSizeProperties
                        = VMSizeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetHardwareProfile;
        });
    }
}
