// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Information about the current running state of the overall upgrade.
 */
@Immutable
public final class UpgradeOperationHistoryStatus implements JsonSerializable<UpgradeOperationHistoryStatus> {
    /*
     * Code indicating the current status of the upgrade.
     */
    private UpgradeState code;

    /*
     * Start time of the upgrade.
     */
    private OffsetDateTime startTime;

    /*
     * End time of the upgrade.
     */
    private OffsetDateTime endTime;

    /**
     * Creates an instance of UpgradeOperationHistoryStatus class.
     */
    public UpgradeOperationHistoryStatus() {
    }

    /**
     * Get the code property: Code indicating the current status of the upgrade.
     * 
     * @return the code value.
     */
    public UpgradeState code() {
        return this.code;
    }

    /**
     * Get the startTime property: Start time of the upgrade.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: End time of the upgrade.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpgradeOperationHistoryStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpgradeOperationHistoryStatus if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpgradeOperationHistoryStatus.
     */
    public static UpgradeOperationHistoryStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpgradeOperationHistoryStatus deserializedUpgradeOperationHistoryStatus
                = new UpgradeOperationHistoryStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedUpgradeOperationHistoryStatus.code = UpgradeState.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedUpgradeOperationHistoryStatus.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedUpgradeOperationHistoryStatus.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpgradeOperationHistoryStatus;
        });
    }
}
