// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Profile for gallery sharing to subscription or tenant.
 */
@Fluent
public final class SharingProfile implements JsonSerializable<SharingProfile> {
    /*
     * This property allows you to specify the permission of sharing gallery. Possible values are: **Private,**
     * **Groups,** **Community.**
     */
    private GallerySharingPermissionTypes permissions;

    /*
     * A list of sharing profile groups.
     */
    private List<SharingProfileGroup> groups;

    /*
     * Information of community gallery if current gallery is shared to community.
     */
    private CommunityGalleryInfo communityGalleryInfo;

    /**
     * Creates an instance of SharingProfile class.
     */
    public SharingProfile() {
    }

    /**
     * Get the permissions property: This property allows you to specify the permission of sharing gallery. Possible
     * values are: **Private,** **Groups,** **Community.**.
     * 
     * @return the permissions value.
     */
    public GallerySharingPermissionTypes permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: This property allows you to specify the permission of sharing gallery. Possible
     * values are: **Private,** **Groups,** **Community.**.
     * 
     * @param permissions the permissions value to set.
     * @return the SharingProfile object itself.
     */
    public SharingProfile withPermissions(GallerySharingPermissionTypes permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the groups property: A list of sharing profile groups.
     * 
     * @return the groups value.
     */
    public List<SharingProfileGroup> groups() {
        return this.groups;
    }

    /**
     * Get the communityGalleryInfo property: Information of community gallery if current gallery is shared to
     * community.
     * 
     * @return the communityGalleryInfo value.
     */
    public CommunityGalleryInfo communityGalleryInfo() {
        return this.communityGalleryInfo;
    }

    /**
     * Set the communityGalleryInfo property: Information of community gallery if current gallery is shared to
     * community.
     * 
     * @param communityGalleryInfo the communityGalleryInfo value to set.
     * @return the SharingProfile object itself.
     */
    public SharingProfile withCommunityGalleryInfo(CommunityGalleryInfo communityGalleryInfo) {
        this.communityGalleryInfo = communityGalleryInfo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (groups() != null) {
            groups().forEach(e -> e.validate());
        }
        if (communityGalleryInfo() != null) {
            communityGalleryInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions == null ? null : this.permissions.toString());
        jsonWriter.writeJsonField("communityGalleryInfo", this.communityGalleryInfo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharingProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharingProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharingProfile.
     */
    public static SharingProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharingProfile deserializedSharingProfile = new SharingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("permissions".equals(fieldName)) {
                    deserializedSharingProfile.permissions
                        = GallerySharingPermissionTypes.fromString(reader.getString());
                } else if ("groups".equals(fieldName)) {
                    List<SharingProfileGroup> groups
                        = reader.readArray(reader1 -> SharingProfileGroup.fromJson(reader1));
                    deserializedSharingProfile.groups = groups;
                } else if ("communityGalleryInfo".equals(fieldName)) {
                    deserializedSharingProfile.communityGalleryInfo = CommunityGalleryInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharingProfile;
        });
    }
}
