// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes an available Compute SKU Restriction Information.
 */
@Immutable
public final class ResourceSkuRestrictionInfo implements JsonSerializable<ResourceSkuRestrictionInfo> {
    /*
     * Locations where the SKU is restricted
     */
    private List<String> locations;

    /*
     * List of availability zones where the SKU is restricted.
     */
    private List<String> zones;

    /**
     * Creates an instance of ResourceSkuRestrictionInfo class.
     */
    public ResourceSkuRestrictionInfo() {
    }

    /**
     * Get the locations property: Locations where the SKU is restricted.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Get the zones property: List of availability zones where the SKU is restricted.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuRestrictionInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuRestrictionInfo if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSkuRestrictionInfo.
     */
    public static ResourceSkuRestrictionInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuRestrictionInfo deserializedResourceSkuRestrictionInfo = new ResourceSkuRestrictionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuRestrictionInfo.locations = locations;
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourceSkuRestrictionInfo.zones = zones;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuRestrictionInfo;
        });
    }
}
