// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * This is the replication status of the gallery image version.
 */
@Immutable
public final class ReplicationStatus implements JsonSerializable<ReplicationStatus> {
    /*
     * This is the aggregated replication status based on all the regional replication status flags.
     */
    private AggregatedReplicationState aggregatedState;

    /*
     * This is a summary of replication status for each region.
     */
    private List<RegionalReplicationStatus> summary;

    /**
     * Creates an instance of ReplicationStatus class.
     */
    public ReplicationStatus() {
    }

    /**
     * Get the aggregatedState property: This is the aggregated replication status based on all the regional replication
     * status flags.
     * 
     * @return the aggregatedState value.
     */
    public AggregatedReplicationState aggregatedState() {
        return this.aggregatedState;
    }

    /**
     * Get the summary property: This is a summary of replication status for each region.
     * 
     * @return the summary value.
     */
    public List<RegionalReplicationStatus> summary() {
        return this.summary;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (summary() != null) {
            summary().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicationStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReplicationStatus.
     */
    public static ReplicationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicationStatus deserializedReplicationStatus = new ReplicationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("aggregatedState".equals(fieldName)) {
                    deserializedReplicationStatus.aggregatedState
                        = AggregatedReplicationState.fromString(reader.getString());
                } else if ("summary".equals(fieldName)) {
                    List<RegionalReplicationStatus> summary
                        = reader.readArray(reader1 -> RegionalReplicationStatus.fromJson(reader1));
                    deserializedReplicationStatus.summary = summary;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicationStatus;
        });
    }
}
