// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies ProxyAgent settings while creating the virtual machine. Minimum api-version: 2023-09-01.
 */
@Fluent
public final class ProxyAgentSettings implements JsonSerializable<ProxyAgentSettings> {
    /*
     * Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.
     */
    private Boolean enabled;

    /*
     * Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or
     * monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it
     * will enforce access control. The default value is Enforce mode.
     */
    private Mode mode;

    /*
     * Increase the value of this property allows user to reset the key used for securing communication channel between
     * guest and host.
     */
    private Integer keyIncarnationId;

    /**
     * Creates an instance of ProxyAgentSettings class.
     */
    public ProxyAgentSettings() {
    }

    /**
     * Get the enabled property: Specifies whether ProxyAgent feature should be enabled on the virtual machine or
     * virtual machine scale set.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Specifies whether ProxyAgent feature should be enabled on the virtual machine or
     * virtual machine scale set.
     * 
     * @param enabled the enabled value to set.
     * @return the ProxyAgentSettings object itself.
     */
    public ProxyAgentSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the mode property: Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent
     * will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode,
     * while in Enforce mode it will enforce access control. The default value is Enforce mode.
     * 
     * @return the mode value.
     */
    public Mode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent
     * will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode,
     * while in Enforce mode it will enforce access control. The default value is Enforce mode.
     * 
     * @param mode the mode value to set.
     * @return the ProxyAgentSettings object itself.
     */
    public ProxyAgentSettings withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the keyIncarnationId property: Increase the value of this property allows user to reset the key used for
     * securing communication channel between guest and host.
     * 
     * @return the keyIncarnationId value.
     */
    public Integer keyIncarnationId() {
        return this.keyIncarnationId;
    }

    /**
     * Set the keyIncarnationId property: Increase the value of this property allows user to reset the key used for
     * securing communication channel between guest and host.
     * 
     * @param keyIncarnationId the keyIncarnationId value to set.
     * @return the ProxyAgentSettings object itself.
     */
    public ProxyAgentSettings withKeyIncarnationId(Integer keyIncarnationId) {
        this.keyIncarnationId = keyIncarnationId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeNumberField("keyIncarnationId", this.keyIncarnationId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProxyAgentSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProxyAgentSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProxyAgentSettings.
     */
    public static ProxyAgentSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProxyAgentSettings deserializedProxyAgentSettings = new ProxyAgentSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedProxyAgentSettings.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("mode".equals(fieldName)) {
                    deserializedProxyAgentSettings.mode = Mode.fromString(reader.getString());
                } else if ("keyIncarnationId".equals(fieldName)) {
                    deserializedProxyAgentSettings.keyIncarnationId = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProxyAgentSettings;
        });
    }
}
