// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a cloud service Extension.
 */
@Fluent
public final class Extension implements JsonSerializable<Extension> {
    /*
     * The name of the extension.
     */
    private String name;

    /*
     * Extension Properties.
     */
    private CloudServiceExtensionProperties properties;

    /**
     * Creates an instance of Extension class.
     */
    public Extension() {
    }

    /**
     * Get the name property: The name of the extension.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the extension.
     * 
     * @param name the name value to set.
     * @return the Extension object itself.
     */
    public Extension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Extension Properties.
     * 
     * @return the properties value.
     */
    public CloudServiceExtensionProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Extension Properties.
     * 
     * @param properties the properties value to set.
     * @return the Extension object itself.
     */
    public Extension withProperties(CloudServiceExtensionProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Extension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Extension if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Extension.
     */
    public static Extension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Extension deserializedExtension = new Extension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedExtension.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedExtension.properties = CloudServiceExtensionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExtension;
        });
    }
}
