// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a data disk.
 */
@Fluent
public final class DataDisk implements JsonSerializable<DataDisk> {
    /*
     * Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and
     * therefore must be unique for each data disk attached to a VM.
     */
    private int lun;

    /*
     * The disk name.
     */
    private String name;

    /*
     * The virtual hard disk.
     */
    private VirtualHardDisk vhd;

    /*
     * The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the
     * virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
     */
    private VirtualHardDisk image;

    /*
     * Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting
     * behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    private CachingTypes caching;

    /*
     * Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    private Boolean writeAcceleratorEnabled;

    /*
     * Specifies how the virtual machine disk should be created. Possible values are **Attach:** This value is used when
     * you are using a specialized disk to create the virtual machine. **FromImage:** This value is used when you are
     * using an image to create the virtual machine data disk. If you are using a platform image, you should also use
     * the imageReference element described above. If you are using a marketplace image, you should also use the plan
     * element previously described. **Empty:** This value is used when creating an empty data disk. **Copy:** This
     * value is used to create a data disk from a snapshot or another disk. **Restore:** This value is used to create a
     * data disk from a disk restore point.
     */
    private DiskCreateOptionTypes createOption;

    /*
     * Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk
     * in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value
     * cannot be larger than 1023.
     */
    private Integer diskSizeGB;

    /*
     * The managed disk parameters.
     */
    private ManagedDiskParameters managedDisk;

    /*
     * The source resource identifier. It can be a snapshot, or disk restore point from which to create a disk.
     */
    private ApiEntityReference sourceResource;

    /*
     * Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
     */
    private Boolean toBeDetached;

    /*
     * Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for
     * VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
     */
    private Long diskIopsReadWrite;

    /*
     * Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned
     * only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine Scale Set.
     */
    private Long diskMBpsReadWrite;

    /*
     * Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment
     * from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for
     * managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected
     * failure from the virtual machine and the disk is still not released then use force-detach as a last resort option
     * to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior.
     * **This feature is still in preview**. To force-detach a data disk update toBeDetached to 'true' along with
     * setting detachOption: 'ForceDetach'.
     */
    private DiskDetachOptionTypes detachOption;

    /*
     * Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If
     * this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk
     * is retained after VM is deleted. The default value is set to **Detach**.
     */
    private DiskDeleteOptionTypes deleteOption;

    /**
     * Creates an instance of DataDisk class.
     */
    public DataDisk() {
    }

    /**
     * Get the lun property: Specifies the logical unit number of the data disk. This value is used to identify data
     * disks within the VM and therefore must be unique for each data disk attached to a VM.
     * 
     * @return the lun value.
     */
    public int lun() {
        return this.lun;
    }

    /**
     * Set the lun property: Specifies the logical unit number of the data disk. This value is used to identify data
     * disks within the VM and therefore must be unique for each data disk attached to a VM.
     * 
     * @param lun the lun value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the name property: The disk name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The disk name.
     * 
     * @param name the name value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the vhd property: The virtual hard disk.
     * 
     * @return the vhd value.
     */
    public VirtualHardDisk vhd() {
        return this.vhd;
    }

    /**
     * Set the vhd property: The virtual hard disk.
     * 
     * @param vhd the vhd value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withVhd(VirtualHardDisk vhd) {
        this.vhd = vhd;
        return this;
    }

    /**
     * Get the image property: The source user image virtual hard disk. The virtual hard disk will be copied before
     * being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not
     * exist.
     * 
     * @return the image value.
     */
    public VirtualHardDisk image() {
        return this.image;
    }

    /**
     * Set the image property: The source user image virtual hard disk. The virtual hard disk will be copied before
     * being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not
     * exist.
     * 
     * @param image the image value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    /**
     * Get the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Set the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @param caching the caching value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Set the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @param writeAcceleratorEnabled the writeAcceleratorEnabled value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    /**
     * Get the createOption property: Specifies how the virtual machine disk should be created. Possible values are
     * **Attach:** This value is used when you are using a specialized disk to create the virtual machine.
     * **FromImage:** This value is used when you are using an image to create the virtual machine data disk. If you are
     * using a platform image, you should also use the imageReference element described above. If you are using a
     * marketplace image, you should also use the plan element previously described. **Empty:** This value is used when
     * creating an empty data disk. **Copy:** This value is used to create a data disk from a snapshot or another disk.
     * **Restore:** This value is used to create a data disk from a disk restore point.
     * 
     * @return the createOption value.
     */
    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    /**
     * Set the createOption property: Specifies how the virtual machine disk should be created. Possible values are
     * **Attach:** This value is used when you are using a specialized disk to create the virtual machine.
     * **FromImage:** This value is used when you are using an image to create the virtual machine data disk. If you are
     * using a platform image, you should also use the imageReference element described above. If you are using a
     * marketplace image, you should also use the plan element previously described. **Empty:** This value is used when
     * creating an empty data disk. **Copy:** This value is used to create a data disk from a snapshot or another disk.
     * **Restore:** This value is used to create a data disk from a disk restore point.
     * 
     * @param createOption the createOption value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    /**
     * Get the diskSizeGB property: Specifies the size of an empty data disk in gigabytes. This element can be used to
     * overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x
     * 1024^3 for the disk and the value cannot be larger than 1023.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: Specifies the size of an empty data disk in gigabytes. This element can be used to
     * overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x
     * 1024^3 for the disk and the value cannot be larger than 1023.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the managedDisk property: The managed disk parameters.
     * 
     * @return the managedDisk value.
     */
    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    /**
     * Set the managedDisk property: The managed disk parameters.
     * 
     * @param managedDisk the managedDisk value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    /**
     * Get the sourceResource property: The source resource identifier. It can be a snapshot, or disk restore point from
     * which to create a disk.
     * 
     * @return the sourceResource value.
     */
    public ApiEntityReference sourceResource() {
        return this.sourceResource;
    }

    /**
     * Set the sourceResource property: The source resource identifier. It can be a snapshot, or disk restore point from
     * which to create a disk.
     * 
     * @param sourceResource the sourceResource value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withSourceResource(ApiEntityReference sourceResource) {
        this.sourceResource = sourceResource;
        return this;
    }

    /**
     * Get the toBeDetached property: Specifies whether the data disk is in process of detachment from the
     * VirtualMachine/VirtualMachineScaleset.
     * 
     * @return the toBeDetached value.
     */
    public Boolean toBeDetached() {
        return this.toBeDetached;
    }

    /**
     * Set the toBeDetached property: Specifies whether the data disk is in process of detachment from the
     * VirtualMachine/VirtualMachineScaleset.
     * 
     * @param toBeDetached the toBeDetached value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withToBeDetached(Boolean toBeDetached) {
        this.toBeDetached = toBeDetached;
        return this;
    }

    /**
     * Get the diskIopsReadWrite property: Specifies the Read-Write IOPS for the managed disk when StorageAccountType is
     * UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the
     * VirtualMachine Scale Set.
     * 
     * @return the diskIopsReadWrite value.
     */
    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    /**
     * Get the diskMBpsReadWrite property: Specifies the bandwidth in MB per second for the managed disk when
     * StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be updated only via
     * updates to the VirtualMachine Scale Set.
     * 
     * @return the diskMBpsReadWrite value.
     */
    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    /**
     * Get the detachOption property: Specifies the detach behavior to be used while detaching a disk or which is
     * already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption:
     * **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did
     * not complete due to an unexpected failure from the virtual machine and the disk is still not released then use
     * force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been
     * flushed when using this detach behavior. **This feature is still in preview**. To force-detach a data disk update
     * toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     * 
     * @return the detachOption value.
     */
    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    /**
     * Set the detachOption property: Specifies the detach behavior to be used while detaching a disk or which is
     * already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption:
     * **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did
     * not complete due to an unexpected failure from the virtual machine and the disk is still not released then use
     * force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been
     * flushed when using this detach behavior. **This feature is still in preview**. To force-detach a data disk update
     * toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     * 
     * @param detachOption the detachOption value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    /**
     * Get the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @return the deleteOption value.
     */
    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vhd() != null) {
            vhd().validate();
        }
        if (image() != null) {
            image().validate();
        }
        if (createOption() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property createOption in model DataDisk"));
        }
        if (managedDisk() != null) {
            managedDisk().validate();
        }
        if (sourceResource() != null) {
            sourceResource().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisk.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("vhd", this.vhd);
        jsonWriter.writeJsonField("image", this.image);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeNumberField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeJsonField("sourceResource", this.sourceResource);
        jsonWriter.writeBooleanField("toBeDetached", this.toBeDetached);
        jsonWriter.writeStringField("detachOption", this.detachOption == null ? null : this.detachOption.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDisk if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataDisk.
     */
    public static DataDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDisk deserializedDataDisk = new DataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lun".equals(fieldName)) {
                    deserializedDataDisk.lun = reader.getInt();
                } else if ("createOption".equals(fieldName)) {
                    deserializedDataDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedDataDisk.name = reader.getString();
                } else if ("vhd".equals(fieldName)) {
                    deserializedDataDisk.vhd = VirtualHardDisk.fromJson(reader);
                } else if ("image".equals(fieldName)) {
                    deserializedDataDisk.image = VirtualHardDisk.fromJson(reader);
                } else if ("caching".equals(fieldName)) {
                    deserializedDataDisk.caching = CachingTypes.fromString(reader.getString());
                } else if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedDataDisk.writeAcceleratorEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedDataDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("managedDisk".equals(fieldName)) {
                    deserializedDataDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                } else if ("sourceResource".equals(fieldName)) {
                    deserializedDataDisk.sourceResource = ApiEntityReference.fromJson(reader);
                } else if ("toBeDetached".equals(fieldName)) {
                    deserializedDataDisk.toBeDetached = reader.getNullable(JsonReader::getBoolean);
                } else if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedDataDisk.diskIopsReadWrite = reader.getNullable(JsonReader::getLong);
                } else if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedDataDisk.diskMBpsReadWrite = reader.getNullable(JsonReader::getLong);
                } else if ("detachOption".equals(fieldName)) {
                    deserializedDataDisk.detachOption = DiskDetachOptionTypes.fromString(reader.getString());
                } else if ("deleteOption".equals(fieldName)) {
                    deserializedDataDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDisk;
        });
    }
}
