// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RunCommandParameterDefinition;
import java.io.IOException;
import java.util.List;

/**
 * Describes the properties of a Run Command.
 */
@Fluent
public final class RunCommandDocumentInner extends RunCommandDocumentBaseInner {
    /*
     * The script to be executed.
     */
    private List<String> script;

    /*
     * The parameters used by the script.
     */
    private List<RunCommandParameterDefinition> parameters;

    /**
     * Creates an instance of RunCommandDocumentInner class.
     */
    public RunCommandDocumentInner() {
    }

    /**
     * Get the script property: The script to be executed.
     * 
     * @return the script value.
     */
    public List<String> script() {
        return this.script;
    }

    /**
     * Set the script property: The script to be executed.
     * 
     * @param script the script value to set.
     * @return the RunCommandDocumentInner object itself.
     */
    public RunCommandDocumentInner withScript(List<String> script) {
        this.script = script;
        return this;
    }

    /**
     * Get the parameters property: The parameters used by the script.
     * 
     * @return the parameters value.
     */
    public List<RunCommandParameterDefinition> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters used by the script.
     * 
     * @param parameters the parameters value to set.
     * @return the RunCommandDocumentInner object itself.
     */
    public RunCommandDocumentInner withParameters(List<RunCommandParameterDefinition> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunCommandDocumentInner withSchema(String schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunCommandDocumentInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunCommandDocumentInner withOsType(OperatingSystemTypes osType) {
        super.withOsType(osType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunCommandDocumentInner withLabel(String label) {
        super.withLabel(label);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunCommandDocumentInner withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (script() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property script in model RunCommandDocumentInner"));
        }
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandDocumentInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$schema", schema());
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("osType", osType() == null ? null : osType().toString());
        jsonWriter.writeStringField("label", label());
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeArrayField("script", this.script, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandDocumentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandDocumentInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandDocumentInner.
     */
    public static RunCommandDocumentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandDocumentInner deserializedRunCommandDocumentInner = new RunCommandDocumentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("$schema".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withSchema(reader.getString());
                } else if ("id".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withId(reader.getString());
                } else if ("osType".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withOsType(OperatingSystemTypes.fromString(reader.getString()));
                } else if ("label".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withLabel(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withDescription(reader.getString());
                } else if ("script".equals(fieldName)) {
                    List<String> script = reader.readArray(reader1 -> reader1.getString());
                    deserializedRunCommandDocumentInner.script = script;
                } else if ("parameters".equals(fieldName)) {
                    List<RunCommandParameterDefinition> parameters
                        = reader.readArray(reader1 -> RunCommandParameterDefinition.fromJson(reader1));
                    deserializedRunCommandDocumentInner.parameters = parameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandDocumentInner;
        });
    }
}
