// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a Compute Operation value.
 */
@Immutable
public final class ComputeOperationValueInner implements JsonSerializable<ComputeOperationValueInner> {
    /*
     * The origin of the compute operation.
     */
    private String origin;

    /*
     * The name of the compute operation.
     */
    private String name;

    /*
     * Describes the properties of a Compute Operation Value Display.
     */
    private ComputeOperationValueDisplay innerDisplay;

    /**
     * Creates an instance of ComputeOperationValueInner class.
     */
    public ComputeOperationValueInner() {
    }

    /**
     * Get the origin property: The origin of the compute operation.
     * 
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Get the name property: The name of the compute operation.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the innerDisplay property: Describes the properties of a Compute Operation Value Display.
     * 
     * @return the innerDisplay value.
     */
    private ComputeOperationValueDisplay innerDisplay() {
        return this.innerDisplay;
    }

    /**
     * Get the operation property: The display name of the compute operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.innerDisplay() == null ? null : this.innerDisplay().operation();
    }

    /**
     * Get the resource property: The display name of the resource the operation applies to.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.innerDisplay() == null ? null : this.innerDisplay().resource();
    }

    /**
     * Get the description property: The description of the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerDisplay() == null ? null : this.innerDisplay().description();
    }

    /**
     * Get the provider property: The resource provider for the operation.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerDisplay() == null ? null : this.innerDisplay().provider();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerDisplay() != null) {
            innerDisplay().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", this.innerDisplay);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ComputeOperationValueInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ComputeOperationValueInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ComputeOperationValueInner.
     */
    public static ComputeOperationValueInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ComputeOperationValueInner deserializedComputeOperationValueInner = new ComputeOperationValueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("origin".equals(fieldName)) {
                    deserializedComputeOperationValueInner.origin = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedComputeOperationValueInner.name = reader.getString();
                } else if ("display".equals(fieldName)) {
                    deserializedComputeOperationValueInner.innerDisplay = ComputeOperationValueDisplay.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedComputeOperationValueInner;
        });
    }
}
