// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProperties;
import com.azure.resourcemanager.compute.models.CloudServiceRoleSku;
import java.io.IOException;

/**
 * Describes a role of the cloud service.
 */
@Fluent
public final class CloudServiceRoleInner implements JsonSerializable<CloudServiceRoleInner> {
    /*
     * Resource id
     */
    private String id;

    /*
     * Resource name
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /*
     * Resource location
     */
    private String location;

    /*
     * Describes the cloud service role sku.
     */
    private CloudServiceRoleSku sku;

    /*
     * The cloud service role properties.
     */
    private CloudServiceRoleProperties properties;

    /**
     * Creates an instance of CloudServiceRoleInner class.
     */
    public CloudServiceRoleInner() {
    }

    /**
     * Get the id property: Resource id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the sku property: Describes the cloud service role sku.
     * 
     * @return the sku value.
     */
    public CloudServiceRoleSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Describes the cloud service role sku.
     * 
     * @param sku the sku value to set.
     * @return the CloudServiceRoleInner object itself.
     */
    public CloudServiceRoleInner withSku(CloudServiceRoleSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the properties property: The cloud service role properties.
     * 
     * @return the properties value.
     */
    public CloudServiceRoleProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The cloud service role properties.
     * 
     * @param properties the properties value to set.
     * @return the CloudServiceRoleInner object itself.
     */
    public CloudServiceRoleInner withProperties(CloudServiceRoleProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceRoleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceRoleInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CloudServiceRoleInner.
     */
    public static CloudServiceRoleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceRoleInner deserializedCloudServiceRoleInner = new CloudServiceRoleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.location = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.sku = CloudServiceRoleSku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.properties = CloudServiceRoleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceRoleInner;
        });
    }
}
