/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ValidateSecretType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ValidateSecretInput {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ValidateSecretInput.class);
    @JsonProperty(value="secretSource", required=true)
    private ResourceReference secretSource;
    @JsonProperty(value="secretType", required=true)
    private ValidateSecretType secretType;

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public ValidateSecretInput withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public ValidateSecretType secretType() {
        return this.secretType;
    }

    public ValidateSecretInput withSecretType(ValidateSecretType secretType) {
        this.secretType = secretType;
        return this;
    }

    public void validate() {
        if (this.secretSource() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model ValidateSecretInput"));
        }
        this.secretSource().validate();
        if (this.secretType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretType in model ValidateSecretInput"));
        }
    }
}

