/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DeliveryRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DeliveryRule.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="order", required=true)
    private int order;
    @JsonProperty(value="conditions")
    private List<DeliveryRuleCondition> conditions;
    @JsonProperty(value="actions", required=true)
    private List<DeliveryRuleAction> actions;

    public String name() {
        return this.name;
    }

    public DeliveryRule withName(String name) {
        this.name = name;
        return this;
    }

    public int order() {
        return this.order;
    }

    public DeliveryRule withOrder(int order) {
        this.order = order;
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    public DeliveryRule withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    public DeliveryRule withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actions() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property actions in model DeliveryRule"));
        }
        this.actions().forEach(e -> e.validate());
    }
}

