/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.LogAnalyticsClient;
import com.azure.resourcemanager.cdn.fluent.models.ContinentsResponseInner;
import com.azure.resourcemanager.cdn.fluent.models.MetricsResponseInner;
import com.azure.resourcemanager.cdn.fluent.models.RankingsResponseInner;
import com.azure.resourcemanager.cdn.fluent.models.ResourcesResponseInner;
import com.azure.resourcemanager.cdn.fluent.models.WafMetricsResponseInner;
import com.azure.resourcemanager.cdn.fluent.models.WafRankingsResponseInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.LogMetric;
import com.azure.resourcemanager.cdn.models.LogMetricsGranularity;
import com.azure.resourcemanager.cdn.models.LogMetricsGroupBy;
import com.azure.resourcemanager.cdn.models.LogRanking;
import com.azure.resourcemanager.cdn.models.LogRankingMetric;
import com.azure.resourcemanager.cdn.models.WafAction;
import com.azure.resourcemanager.cdn.models.WafGranularity;
import com.azure.resourcemanager.cdn.models.WafMetric;
import com.azure.resourcemanager.cdn.models.WafRankingGroupBy;
import com.azure.resourcemanager.cdn.models.WafRankingType;
import com.azure.resourcemanager.cdn.models.WafRuleType;
import java.time.OffsetDateTime;
import java.util.List;
import reactor.core.publisher.Mono;

public final class LogAnalyticsClientImpl
implements LogAnalyticsClient {
    private final ClientLogger logger = new ClientLogger(LogAnalyticsClientImpl.class);
    private final LogAnalyticsService service;
    private final CdnManagementClientImpl client;

    LogAnalyticsClientImpl(CdnManagementClientImpl client) {
        this.service = (LogAnalyticsService)RestProxy.create(LogAnalyticsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetricsResponseInner>> getLogAnalyticsMetricsWithResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (granularity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter granularity is required and cannot be null."));
        }
        if (customDomains == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomains is required and cannot be null."));
        }
        if (protocols == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter protocols is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String groupByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(groupBy, CollectionFormat.CSV);
        String continentsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(continents, CollectionFormat.CSV);
        String countryOrRegionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(countryOrRegions, CollectionFormat.CSV);
        String customDomainsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(customDomains, CollectionFormat.CSV);
        String protocolsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(protocols, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getLogAnalyticsMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MetricsResponseInner>> getLogAnalyticsMetricsWithResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (granularity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter granularity is required and cannot be null."));
        }
        if (customDomains == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomains is required and cannot be null."));
        }
        if (protocols == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter protocols is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String groupByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(groupBy, CollectionFormat.CSV);
        String continentsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(continents, CollectionFormat.CSV);
        String countryOrRegionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(countryOrRegions, CollectionFormat.CSV);
        String customDomainsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(customDomains, CollectionFormat.CSV);
        String protocolsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(protocols, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getLogAnalyticsMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        return this.getLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        List<LogMetricsGroupBy> groupBy = null;
        List<String> continents = null;
        List<String> countryOrRegions = null;
        return this.getLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MetricsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsResponseInner getLogAnalyticsMetrics(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        List<LogMetricsGroupBy> groupBy = null;
        List<String> continents = null;
        List<String> countryOrRegions = null;
        return (MetricsResponseInner)this.getLogAnalyticsMetricsAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsResponseInner> getLogAnalyticsMetricsWithResponse(String resourceGroupName, String profileName, List<LogMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions, Context context) {
        return (Response)this.getLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RankingsResponseInner>> getLogAnalyticsRankingsWithResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, List<String> customDomains) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (rankings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rankings is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        String accept = "application/json";
        String rankingsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(rankings, CollectionFormat.CSV);
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String customDomainsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(customDomains, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getLogAnalyticsRankings(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RankingsResponseInner>> getLogAnalyticsRankingsWithResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, List<String> customDomains, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (rankings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rankings is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        String accept = "application/json";
        String rankingsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(rankings, CollectionFormat.CSV);
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String customDomainsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(customDomains, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getLogAnalyticsRankings(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, List<String> customDomains) {
        return this.getLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RankingsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd) {
        List<String> customDomains = null;
        return this.getLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RankingsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RankingsResponseInner getLogAnalyticsRankings(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd) {
        List<String> customDomains = null;
        return (RankingsResponseInner)this.getLogAnalyticsRankingsAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RankingsResponseInner> getLogAnalyticsRankingsWithResponse(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, List<String> customDomains, Context context) {
        return (Response)this.getLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContinentsResponseInner>> getLogAnalyticsLocationsWithResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLogAnalyticsLocations(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContinentsResponseInner>> getLogAnalyticsLocationsWithResponseAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getLogAnalyticsLocations(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContinentsResponseInner> getLogAnalyticsLocationsAsync(String resourceGroupName, String profileName) {
        return this.getLogAnalyticsLocationsWithResponseAsync(resourceGroupName, profileName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ContinentsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContinentsResponseInner getLogAnalyticsLocations(String resourceGroupName, String profileName) {
        return (ContinentsResponseInner)this.getLogAnalyticsLocationsAsync(resourceGroupName, profileName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContinentsResponseInner> getLogAnalyticsLocationsWithResponse(String resourceGroupName, String profileName, Context context) {
        return (Response)this.getLogAnalyticsLocationsWithResponseAsync(resourceGroupName, profileName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourcesResponseInner>> getLogAnalyticsResourcesWithResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLogAnalyticsResources(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourcesResponseInner>> getLogAnalyticsResourcesWithResponseAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getLogAnalyticsResources(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourcesResponseInner> getLogAnalyticsResourcesAsync(String resourceGroupName, String profileName) {
        return this.getLogAnalyticsResourcesWithResponseAsync(resourceGroupName, profileName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ResourcesResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourcesResponseInner getLogAnalyticsResources(String resourceGroupName, String profileName) {
        return (ResourcesResponseInner)this.getLogAnalyticsResourcesAsync(resourceGroupName, profileName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourcesResponseInner> getLogAnalyticsResourcesWithResponse(String resourceGroupName, String profileName, Context context) {
        return (Response)this.getLogAnalyticsResourcesWithResponseAsync(resourceGroupName, profileName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (granularity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter granularity is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String actionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(actions, CollectionFormat.CSV);
        String groupByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(groupBy, CollectionFormat.CSV);
        String ruleTypesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(ruleTypes, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getWafLogAnalyticsMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (granularity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter granularity is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String actionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(actions, CollectionFormat.CSV);
        String groupByConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(groupBy, CollectionFormat.CSV);
        String ruleTypesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(ruleTypes, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getWafLogAnalyticsMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        return this.getWafLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((WafMetricsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity) {
        List<WafAction> actions = null;
        List<WafRankingGroupBy> groupBy = null;
        List<WafRuleType> ruleTypes = null;
        return this.getWafLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((WafMetricsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WafMetricsResponseInner getWafLogAnalyticsMetrics(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity) {
        List<WafAction> actions = null;
        List<WafRankingGroupBy> groupBy = null;
        List<WafRuleType> ruleTypes = null;
        return (WafMetricsResponseInner)this.getWafLogAnalyticsMetricsAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WafMetricsResponseInner> getWafLogAnalyticsMetricsWithResponse(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes, Context context) {
        return (Response)this.getWafLogAnalyticsMetricsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (rankings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rankings is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String rankingsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(rankings, CollectionFormat.CSV);
        String actionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(actions, CollectionFormat.CSV);
        String ruleTypesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(ruleTypes, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getWafLogAnalyticsRankings(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (metrics == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metrics is required and cannot be null."));
        }
        if (dateTimeBegin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null."));
        }
        if (dateTimeEnd == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null."));
        }
        if (rankings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rankings is required and cannot be null."));
        }
        String accept = "application/json";
        String metricsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(metrics, CollectionFormat.CSV);
        String rankingsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(rankings, CollectionFormat.CSV);
        String actionsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(actions, CollectionFormat.CSV);
        String ruleTypesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(ruleTypes, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getWafLogAnalyticsRankings(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), profileName, metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        return this.getWafLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((WafRankingsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        List<WafAction> actions = null;
        List<WafRuleType> ruleTypes = null;
        return this.getWafLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((WafRankingsResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WafRankingsResponseInner getWafLogAnalyticsRankings(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        List<WafAction> actions = null;
        List<WafRuleType> ruleTypes = null;
        return (WafRankingsResponseInner)this.getWafLogAnalyticsRankingsAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WafRankingsResponseInner> getWafLogAnalyticsRankingsWithResponse(String resourceGroupName, String profileName, List<WafMetric> metrics, OffsetDateTime dateTimeBegin, OffsetDateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes, Context context) {
        return (Response)this.getWafLogAnalyticsRankingsWithResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientL")
    private static interface LogAnalyticsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricsResponseInner>> getLogAnalyticsMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @QueryParam(value="metrics") String var6, @QueryParam(value="dateTimeBegin") OffsetDateTime var7, @QueryParam(value="dateTimeEnd") OffsetDateTime var8, @QueryParam(value="granularity") LogMetricsGranularity var9, @QueryParam(value="groupBy") String var10, @QueryParam(value="continents") String var11, @QueryParam(value="countryOrRegions") String var12, @QueryParam(value="customDomains") String var13, @QueryParam(value="protocols") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RankingsResponseInner>> getLogAnalyticsRankings(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @QueryParam(value="rankings") String var6, @QueryParam(value="metrics") String var7, @QueryParam(value="maxRanking") int var8, @QueryParam(value="dateTimeBegin") OffsetDateTime var9, @QueryParam(value="dateTimeEnd") OffsetDateTime var10, @QueryParam(value="customDomains") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContinentsResponseInner>> getLogAnalyticsLocations(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourcesResponseInner>> getLogAnalyticsResources(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WafMetricsResponseInner>> getWafLogAnalyticsMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @QueryParam(value="metrics") String var6, @QueryParam(value="dateTimeBegin") OffsetDateTime var7, @QueryParam(value="dateTimeEnd") OffsetDateTime var8, @QueryParam(value="granularity") WafGranularity var9, @QueryParam(value="actions") String var10, @QueryParam(value="groupBy") String var11, @QueryParam(value="ruleTypes") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WafRankingsResponseInner>> getWafLogAnalyticsRankings(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="profileName") String var5, @QueryParam(value="metrics") String var6, @QueryParam(value="dateTimeBegin") OffsetDateTime var7, @QueryParam(value="dateTimeEnd") OffsetDateTime var8, @QueryParam(value="maxRanking") int var9, @QueryParam(value="rankings") String var10, @QueryParam(value="actions") String var11, @QueryParam(value="ruleTypes") String var12, @HeaderParam(value="Accept") String var13, Context var14);
    }
}

