/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.cdn.CdnManager;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.azure.resourcemanager.cdn.fluent.models.SsoUriInner;
import com.azure.resourcemanager.cdn.implementation.CdnEndpointImpl;
import com.azure.resourcemanager.cdn.implementation.CdnEndpointsImpl;
import com.azure.resourcemanager.cdn.models.CdnEndpoint;
import com.azure.resourcemanager.cdn.models.CdnProfile;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.cdn.models.CustomDomainValidationResult;
import com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.azure.resourcemanager.cdn.models.Sku;
import com.azure.resourcemanager.cdn.models.SkuName;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

class CdnProfileImpl
extends GroupableResourceImpl<CdnProfile, ProfileInner, CdnProfileImpl, CdnManager>
implements CdnProfile,
CdnProfile.Definition,
CdnProfile.Update {
    private CdnEndpointsImpl endpoints = new CdnEndpointsImpl(this);

    CdnProfileImpl(String name, ProfileInner innerModel, CdnManager cdnManager) {
        super(name, (Resource)innerModel, (Manager)cdnManager);
    }

    @Override
    public Map<String, CdnEndpoint> endpoints() {
        return this.endpoints.endpointsAsMap();
    }

    @Override
    public String generateSsoUri() {
        return (String)this.generateSsoUriAsync().block();
    }

    @Override
    public Mono<String> generateSsoUriAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().generateSsoUriAsync(this.resourceGroupName(), this.name()).map(SsoUriInner::ssoUriValue);
    }

    @Override
    public void startEndpoint(String endpointName) {
        this.startEndpointAsync(endpointName).block();
    }

    @Override
    public Mono<Void> startEndpointAsync(String endpointName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().startAsync(this.resourceGroupName(), this.name(), endpointName).then();
    }

    @Override
    public void stopEndpoint(String endpointName) {
        this.stopEndpointAsync(endpointName).block();
    }

    @Override
    public Mono<Void> stopEndpointAsync(String endpointName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().stopAsync(this.resourceGroupName(), this.name(), endpointName).then();
    }

    @Override
    public PagedIterable<ResourceUsage> listResourceUsage() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().listResourceUsage(this.resourceGroupName(), this.name()), ResourceUsage::new);
    }

    @Override
    public void purgeEndpointContent(String endpointName, Set<String> contentPaths) {
        this.purgeEndpointContentAsync(endpointName, contentPaths).block();
    }

    @Override
    public Mono<Void> purgeEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().purgeContentAsync(this.resourceGroupName(), this.name(), endpointName, new ArrayList<String>(contentPaths));
        }
        return Mono.empty();
    }

    @Override
    public void loadEndpointContent(String endpointName, Set<String> contentPaths) {
        this.loadEndpointContentAsync(endpointName, contentPaths).block();
    }

    @Override
    public Mono<Void> loadEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().loadContentAsync(this.resourceGroupName(), this.name(), endpointName, new ArrayList<String>(contentPaths));
        }
        return Mono.empty();
    }

    @Override
    public CustomDomainValidationResult validateEndpointCustomDomain(String endpointName, String hostName) {
        return (CustomDomainValidationResult)this.validateEndpointCustomDomainAsync(endpointName, hostName).block();
    }

    @Override
    public Mono<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String endpointName, String hostName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().validateCustomDomainAsync(this.resourceGroupName(), this.name(), endpointName, hostName).map(CustomDomainValidationResult::new);
    }

    @Override
    public CheckNameAvailabilityResult checkEndpointNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkEndpointNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name) {
        return ((CdnManager)this.manager()).profiles().checkEndpointNameAvailabilityAsync(name);
    }

    @Override
    public boolean isPremiumVerizon() {
        return this.sku() != null && this.sku().name() != null && this.sku().name().equals((Object)SkuName.PREMIUM_VERIZON);
    }

    public String regionName() {
        return ((ProfileInner)((Object)this.innerModel())).location();
    }

    @Override
    public Sku sku() {
        return ((ProfileInner)((Object)this.innerModel())).sku();
    }

    @Override
    public String resourceState() {
        return ((ProfileInner)((Object)this.innerModel())).resourceState().toString();
    }

    protected Mono<ProfileInner> getInnerAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<CdnProfile> createResourceAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().createAsync(this.resourceGroupName(), this.name(), (ProfileInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<CdnProfile> updateResourceAsync() {
        CdnProfileImpl self = this;
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().updateAsync(this.resourceGroupName(), this.name(), ((ProfileInner)((Object)this.innerModel())).tags()).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (isGroupFaulted) {
            this.endpoints.clear();
            return Mono.empty();
        }
        return this.refreshAsync().then();
    }

    public Mono<CdnProfile> refreshAsync() {
        return super.refreshAsync().map(cdnProfile -> {
            this.endpoints.clear();
            return cdnProfile;
        });
    }

    @Override
    public CdnProfileImpl withStandardAkamaiSku() {
        ((ProfileInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.STANDARD_AKAMAI));
        return this;
    }

    @Override
    public CdnProfileImpl withStandardVerizonSku() {
        ((ProfileInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.STANDARD_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withPremiumVerizonSku() {
        ((ProfileInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.PREMIUM_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withSku(SkuName skuName) {
        ((ProfileInner)((Object)this.innerModel())).withSku(new Sku().withName(skuName));
        return this;
    }

    @Override
    public CdnProfileImpl withNewEndpoint(String endpointOriginHostname) {
        CdnEndpointImpl endpoint = this.endpoints.defineNewEndpointWithOriginHostname(endpointOriginHostname);
        this.endpoints.addEndpoint(endpoint);
        return this;
    }

    public CdnEndpointImpl defineNewEndpoint() {
        return this.endpoints.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewEndpoint(String name) {
        return this.endpoints.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewEndpoint(String name, String endpointOriginHostname) {
        return this.endpoints.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnProfileImpl withNewPremiumEndpoint(String endpointOriginHostname) {
        return this.withNewEndpoint(endpointOriginHostname);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint() {
        return this.endpoints.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name) {
        return this.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name, String endpointOriginHostname) {
        return this.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnEndpointImpl updateEndpoint(String name) {
        return this.endpoints.updateEndpoint(name);
    }

    @Override
    public CdnEndpointImpl updatePremiumEndpoint(String name) {
        return this.endpoints.updateEndpoint(name);
    }

    @Override
    public CdnProfile.Update withoutEndpoint(String name) {
        this.endpoints.remove(name);
        return this;
    }

    CdnProfileImpl withEndpoint(CdnEndpointImpl endpoint) {
        this.endpoints.addEndpoint(endpoint);
        return this;
    }
}

