/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class AfdOriginInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AfdOriginInner.class);
    @JsonProperty(value="properties.azureOrigin")
    private ResourceReference azureOrigin;
    @JsonProperty(value="properties.hostName")
    private String hostname;
    @JsonProperty(value="properties.httpPort")
    private Integer httpPort;
    @JsonProperty(value="properties.httpsPort")
    private Integer httpsPort;
    @JsonProperty(value="properties.originHostHeader")
    private String originHostHeader;
    @JsonProperty(value="properties.priority")
    private Integer priority;
    @JsonProperty(value="properties.weight")
    private Integer weight;
    @JsonProperty(value="properties.sharedPrivateLinkResource")
    private Object sharedPrivateLinkResource;
    @JsonProperty(value="properties.enabledState")
    private EnabledState enabledState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public ResourceReference azureOrigin() {
        return this.azureOrigin;
    }

    public AfdOriginInner withAzureOrigin(ResourceReference azureOrigin) {
        this.azureOrigin = azureOrigin;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public AfdOriginInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public AfdOriginInner withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public AfdOriginInner withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public AfdOriginInner withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public AfdOriginInner withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public AfdOriginInner withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public Object sharedPrivateLinkResource() {
        return this.sharedPrivateLinkResource;
    }

    public AfdOriginInner withSharedPrivateLinkResource(Object sharedPrivateLinkResource) {
        this.sharedPrivateLinkResource = sharedPrivateLinkResource;
        return this;
    }

    public EnabledState enabledState() {
        return this.enabledState;
    }

    public AfdOriginInner withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.azureOrigin() != null) {
            this.azureOrigin().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

