/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class AfdEndpointInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AfdEndpointInner.class);
    @JsonProperty(value="properties.originResponseTimeoutSeconds")
    private Integer originResponseTimeoutSeconds;
    @JsonProperty(value="properties.enabledState")
    private EnabledState enabledState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="properties.hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    public AfdEndpointInner withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    public EnabledState enabledState() {
        return this.enabledState;
    }

    public AfdEndpointInner withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public String hostname() {
        return this.hostname;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public AfdEndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AfdEndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

