// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Input of the secret to be validated. */
@Fluent
public final class ValidateSecretInput {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ValidateSecretInput.class);

    /*
     * The secret source.
     */
    @JsonProperty(value = "secretSource", required = true)
    private ResourceReference secretSource;

    /*
     * The secret type.
     */
    @JsonProperty(value = "secretType", required = true)
    private ValidateSecretType secretType;

    /**
     * Get the secretSource property: The secret source.
     *
     * @return the secretSource value.
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set the secretSource property: The secret source.
     *
     * @param secretSource the secretSource value to set.
     * @return the ValidateSecretInput object itself.
     */
    public ValidateSecretInput withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get the secretType property: The secret type.
     *
     * @return the secretType value.
     */
    public ValidateSecretType secretType() {
        return this.secretType;
    }

    /**
     * Set the secretType property: The secret type.
     *
     * @param secretType the secretType value to set.
     * @return the ValidateSecretInput object itself.
     */
    public ValidateSecretInput withSecretType(ValidateSecretType secretType) {
        this.secretType = secretType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secretSource() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property secretSource in model ValidateSecretInput"));
        } else {
            secretSource().validate();
        }
        if (secretType() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property secretType in model ValidateSecretInput"));
        }
    }
}
