// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The JSON object that contains the properties of the Routes to create. */
@Immutable
public final class RouteProperties extends RouteUpdatePropertiesParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RouteProperties.class);

    /*
     * Provisioning status
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /*
     * The deploymentStatus property.
     */
    @JsonProperty(value = "deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /**
     * Get the provisioningState property: Provisioning status.
     *
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     *
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withCustomDomains(List<ResourceReference> customDomains) {
        super.withCustomDomains(customDomains);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withOriginGroup(ResourceReference originGroup) {
        super.withOriginGroup(originGroup);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withOriginPath(String originPath) {
        super.withOriginPath(originPath);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withRuleSets(List<ResourceReference> ruleSets) {
        super.withRuleSets(ruleSets);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withSupportedProtocols(List<AfdEndpointProtocols> supportedProtocols) {
        super.withSupportedProtocols(supportedProtocols);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withPatternsToMatch(List<String> patternsToMatch) {
        super.withPatternsToMatch(patternsToMatch);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withCompressionSettings(Object compressionSettings) {
        super.withCompressionSettings(compressionSettings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withQueryStringCachingBehavior(AfdQueryStringCachingBehavior queryStringCachingBehavior) {
        super.withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        super.withForwardingProtocol(forwardingProtocol);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        super.withLinkToDefaultDomain(linkToDefaultDomain);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withHttpsRedirect(HttpsRedirect httpsRedirect) {
        super.withHttpsRedirect(httpsRedirect);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RouteProperties withEnabledState(EnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
