// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Certificate used for https. */
@Fluent
public class Certificate {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Certificate.class);

    /*
     * Subject name in the certificate.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /*
     * Certificate expiration date.
     */
    @JsonProperty(value = "expirationDate")
    private String expirationDate;

    /*
     * Certificate thumbprint.
     */
    @JsonProperty(value = "thumbprint")
    private String thumbprint;

    /**
     * Get the subject property: Subject name in the certificate.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: Subject name in the certificate.
     *
     * @param subject the subject value to set.
     * @return the Certificate object itself.
     */
    public Certificate withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     *
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Set the expirationDate property: Certificate expiration date.
     *
     * @param expirationDate the expirationDate value to set.
     * @return the Certificate object itself.
     */
    public Certificate withExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    /**
     * Get the thumbprint property: Certificate thumbprint.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint property: Certificate thumbprint.
     *
     * @param thumbprint the thumbprint value to set.
     * @return the Certificate object itself.
     */
    public Certificate withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
