// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.AfdOriginsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginInner;
import com.azure.resourcemanager.cdn.models.AfdOriginListResult;
import com.azure.resourcemanager.cdn.models.AfdOriginUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AfdOriginsClient. */
public final class AfdOriginsClientImpl implements AfdOriginsClient {
    private final ClientLogger logger = new ClientLogger(AfdOriginsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final AfdOriginsService service;

    /** The service client containing this operation class. */
    private final CdnManagementClientImpl client;

    /**
     * Initializes an instance of AfdOriginsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    AfdOriginsClientImpl(CdnManagementClientImpl client) {
        this.service =
            RestProxy.create(AfdOriginsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CdnManagementClientAfdOrigins to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CdnManagementClientA")
    private interface AfdOriginsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/originGroups/{originGroupName}/origins")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginListResult>> listByOriginGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName,
            @PathParam("originName") String originName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName,
            @PathParam("originName") String originName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdOriginInner origin,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName,
            @PathParam("originName") String originName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdOriginUpdateParameters originUpdateProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName,
            @PathParam("originName") String originName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginListResult>> listByOriginGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupSinglePageAsync(
        String resourceGroupName, String profileName, String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByOriginGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            originGroupName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<AfdOriginInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupSinglePageAsync(
        String resourceGroupName, String profileName, String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByOriginGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                originGroupName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AfdOriginInner> listByOriginGroupAsync(
        String resourceGroupName, String profileName, String originGroupName) {
        return new PagedFlux<>(
            () -> listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName),
            nextLink -> listByOriginGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AfdOriginInner> listByOriginGroupAsync(
        String resourceGroupName, String profileName, String originGroupName, Context context) {
        return new PagedFlux<>(
            () -> listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName, context),
            nextLink -> listByOriginGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdOriginInner> listByOriginGroup(
        String resourceGroupName, String profileName, String originGroupName) {
        return new PagedIterable<>(listByOriginGroupAsync(resourceGroupName, profileName, originGroupName));
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdOriginInner> listByOriginGroup(
        String resourceGroupName, String profileName, String originGroupName, Context context) {
        return new PagedIterable<>(listByOriginGroupAsync(resourceGroupName, profileName, originGroupName, context));
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AfdOriginInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            originGroupName,
                            originName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AfdOriginInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                originGroupName,
                originName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginInner> getAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        return getWithResponseAsync(resourceGroupName, profileName, originGroupName, originName)
            .flatMap(
                (Response<AfdOriginInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginInner get(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return getAsync(resourceGroupName, profileName, originGroupName, originName).block();
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AfdOriginInner> getWithResponse(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return getWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, context).block();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (origin == null) {
            return Mono.error(new IllegalArgumentException("Parameter origin is required and cannot be null."));
        } else {
            origin.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            originGroupName,
                            originName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            origin,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (origin == null) {
            return Mono.error(new IllegalArgumentException("Parameter origin is required and cannot be null."));
        } else {
            origin.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                originGroupName,
                originName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                origin,
                accept,
                context);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginCreateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin);
        return this
            .client
            .<AfdOriginInner, AfdOriginInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AfdOriginInner.class,
                AfdOriginInner.class,
                this.client.getContext());
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginCreateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin, context);
        return this
            .client
            .<AfdOriginInner, AfdOriginInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdOriginInner.class, AfdOriginInner.class, context);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin).getSyncPoller();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin, context)
            .getSyncPoller();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginInner> createAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdOriginInner> createAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginInner create(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin) {
        return createAsync(resourceGroupName, profileName, originGroupName, originName, origin).block();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginInner create(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context) {
        return createAsync(resourceGroupName, profileName, originGroupName, originName, origin, context).block();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originUpdateProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null."));
        } else {
            originUpdateProperties.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            originGroupName,
                            originName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            originUpdateProperties,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originUpdateProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null."));
        } else {
            originUpdateProperties.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                originGroupName,
                originName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                originUpdateProperties,
                accept,
                context);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName, profileName, originGroupName, originName, originUpdateProperties);
        return this
            .client
            .<AfdOriginInner, AfdOriginInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                AfdOriginInner.class,
                AfdOriginInner.class,
                this.client.getContext());
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context);
        return this
            .client
            .<AfdOriginInner, AfdOriginInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdOriginInner.class, AfdOriginInner.class, context);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties) {
        return beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties)
            .getSyncPoller();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties) {
        return beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdOriginInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginInner update(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties) {
        return updateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).block();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginInner update(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context) {
        return updateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context)
            .block();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            originGroupName,
                            originName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error(new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                originGroupName,
                originName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, profileName, originGroupName, originName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName).getSyncPoller();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName, context).getSyncPoller();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        deleteAsync(resourceGroupName, profileName, originGroupName, originName).block();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        deleteAsync(resourceGroupName, profileName, originGroupName, originName, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByOriginGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AfdOriginInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByOriginGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
