// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.azure.resourcemanager.cdn.models.Sku;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Defines web application firewall policy for Azure CDN. */
@JsonFlatten
@Fluent
public class CdnWebApplicationFirewallPolicyInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CdnWebApplicationFirewallPolicyInner.class);

    /*
     * Gets a unique read-only string that changes whenever the resource is
     * updated.
     */
    @JsonProperty(value = "etag")
    private String etag;

    /*
     * The pricing tier (defines a CDN provider, feature list and rate) of the
     * CdnWebApplicationFirewallPolicy.
     */
    @JsonProperty(value = "sku", required = true)
    private Sku sku;

    /*
     * Describes  policySettings for policy
     */
    @JsonProperty(value = "properties.policySettings")
    private PolicySettings policySettings;

    /*
     * Describes rate limit rules inside the policy.
     */
    @JsonProperty(value = "properties.rateLimitRules")
    private RateLimitRuleList rateLimitRules;

    /*
     * Describes custom rules inside the policy.
     */
    @JsonProperty(value = "properties.customRules")
    private CustomRuleList customRules;

    /*
     * Describes managed rules inside the policy.
     */
    @JsonProperty(value = "properties.managedRules")
    private ManagedRuleSetList managedRules;

    /*
     * Describes Azure CDN endpoints associated with this Web Application
     * Firewall policy.
     */
    @JsonProperty(value = "properties.endpointLinks", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointResource> endpointLinks;

    /*
     * Provisioning state of the WebApplicationFirewallPolicy.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Resource status of the policy.
     */
    @JsonProperty(value = "properties.resourceState", access = JsonProperty.Access.WRITE_ONLY)
    private PolicyResourceState resourceState;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the etag property: Gets a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: Gets a unique read-only string that changes whenever the resource is updated.
     *
     * @param etag the etag value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the sku property: The pricing tier (defines a CDN provider, feature list and rate) of the
     * CdnWebApplicationFirewallPolicy.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The pricing tier (defines a CDN provider, feature list and rate) of the
     * CdnWebApplicationFirewallPolicy.
     *
     * @param sku the sku value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the policySettings property: Describes policySettings for policy.
     *
     * @return the policySettings value.
     */
    public PolicySettings policySettings() {
        return this.policySettings;
    }

    /**
     * Set the policySettings property: Describes policySettings for policy.
     *
     * @param policySettings the policySettings value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    /**
     * Get the rateLimitRules property: Describes rate limit rules inside the policy.
     *
     * @return the rateLimitRules value.
     */
    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    /**
     * Set the rateLimitRules property: Describes rate limit rules inside the policy.
     *
     * @param rateLimitRules the rateLimitRules value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    /**
     * Get the customRules property: Describes custom rules inside the policy.
     *
     * @return the customRules value.
     */
    public CustomRuleList customRules() {
        return this.customRules;
    }

    /**
     * Set the customRules property: Describes custom rules inside the policy.
     *
     * @param customRules the customRules value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    /**
     * Get the managedRules property: Describes managed rules inside the policy.
     *
     * @return the managedRules value.
     */
    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    /**
     * Set the managedRules property: Describes managed rules inside the policy.
     *
     * @param managedRules the managedRules value to set.
     * @return the CdnWebApplicationFirewallPolicyInner object itself.
     */
    public CdnWebApplicationFirewallPolicyInner withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    /**
     * Get the endpointLinks property: Describes Azure CDN endpoints associated with this Web Application Firewall
     * policy.
     *
     * @return the endpointLinks value.
     */
    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    /**
     * Get the provisioningState property: Provisioning state of the WebApplicationFirewallPolicy.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceState property: Resource status of the policy.
     *
     * @return the resourceState value.
     */
    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /** {@inheritDoc} */
    @Override
    public CdnWebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CdnWebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property sku in model CdnWebApplicationFirewallPolicyInner"));
        } else {
            sku().validate();
        }
        if (policySettings() != null) {
            policySettings().validate();
        }
        if (rateLimitRules() != null) {
            rateLimitRules().validate();
        }
        if (customRules() != null) {
            customRules().validate();
        }
        if (managedRules() != null) {
            managedRules().validate();
        }
        if (endpointLinks() != null) {
            endpointLinks().forEach(e -> e.validate());
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }
}
