// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginInner;
import com.azure.resourcemanager.cdn.models.AfdOriginUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AfdOriginsClient. */
public interface AfdOriginsClient {
    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AfdOriginInner> listByOriginGroupAsync(
        String resourceGroupName, String profileName, String originGroupName);

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AfdOriginInner> listByOriginGroup(
        String resourceGroupName, String profileName, String originGroupName);

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origins.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AfdOriginInner> listByOriginGroup(
        String resourceGroupName, String profileName, String originGroupName, Context context);

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AfdOriginInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdOriginInner> getAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdOriginInner get(String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin within an origin group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AfdOriginInner> getWithResponse(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginCreateAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(
        String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdOriginInner> createAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdOriginInner create(
        String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin);

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdOriginInner create(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginInner origin,
        Context context);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdOriginInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdOriginInner update(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties);

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN origin is the source of the content being delivered via CDN.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdOriginInner update(
        String resourceGroupName,
        String profileName,
        String originGroupName,
        String originName,
        AfdOriginUpdateParameters originUpdateProperties,
        Context context);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String profileName, String originGroupName, String originName);

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(
        String resourceGroupName, String profileName, String originGroupName, String originName, Context context);
}
