// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.models.AfdDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidationTokenInner;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AfdCustomDomainsClient. */
public interface AfdCustomDomainsClient {
    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AfdDomainInner> listByProfileAsync(String resourceGroupName, String profileName);

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName);

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName, Context context);

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AfdDomainInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner get(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AfdDomainInner> getWithResponse(
        String resourceGroupName, String profileName, String customDomainName, Context context);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginCreateAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdDomainInner> createAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner create(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain);

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner create(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdDomainInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AfdDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner update(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner update(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AfdDomainInner update(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String customDomainName, Context context);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String profileName, String customDomainName, Context context);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> refreshValidationTokenWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName, Context context);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ValidationTokenInner> refreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ValidationTokenInner refreshValidationToken(String resourceGroupName, String profileName, String customDomainName);

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ValidationTokenInner refreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName, Context context);
}
